/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.actions;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.Window;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InspectScreenshotAction
extends Action
implements ImageAction,
DeviceSelectionModel.IWindowChangeListener {
    private static InspectScreenshotAction sAction;
    private Image mImage;

    private InspectScreenshotAction() {
        super("Inspect &Screenshot");
        this.setAccelerator(SWT.MOD1 + 83);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("inspect-screenshot.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mImage));
        this.setToolTipText("Inspect a screenshot in the pixel perfect view");
        this.setEnabled(DeviceSelectionModel.getModel().getSelectedDevice() != null);
        DeviceSelectionModel.getModel().addWindowChangeListener(this);
    }

    public static InspectScreenshotAction getAction() {
        if (sAction == null) {
            sAction = new InspectScreenshotAction();
        }
        return sAction;
    }

    public void run() {
        HierarchyViewerDirector.getDirector().inspectScreenshot();
    }

    @Override
    public Image getImage() {
        return this.mImage;
    }

    @Override
    public void deviceChanged(IHvDevice device) {
    }

    @Override
    public void deviceConnected(IHvDevice device) {
    }

    @Override
    public void deviceDisconnected(IHvDevice device) {
    }

    @Override
    public void focusChanged(IHvDevice device) {
    }

    @Override
    public void selectionChanged(final IHvDevice device, Window window) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                InspectScreenshotAction.getAction().setEnabled(device != null);
            }
        });
    }
}

