/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.hostcommandhandlers;

import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.hostcommandhandlers.HostCommandHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class ListDevicesCommandHandler
extends HostCommandHandler {
    public static final String COMMAND = "devices";

    static String formatDeviceList(List<DeviceState> deviceList) {
        StringBuilder builder = new StringBuilder();
        for (DeviceState deviceState : deviceList) {
            builder.append(deviceState.getDeviceId());
            builder.append("\t");
            builder.append(deviceState.getDeviceStatus().getState());
            builder.append("\n");
        }
        if (!deviceList.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public boolean invoke(FakeAdbServer fakeAdbServer, Socket responseSocket, DeviceState device, String args) {
        OutputStream stream;
        try {
            stream = responseSocket.getOutputStream();
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            String deviceListString = ListDevicesCommandHandler.formatDeviceList(fakeAdbServer.getDeviceListCopy().get());
            try {
                ListDevicesCommandHandler.writeOkay(stream);
                ListDevicesCommandHandler.write4ByteHexIntString(stream, deviceListString.length());
                stream.write(deviceListString.getBytes(StandardCharsets.US_ASCII));
            }
            catch (IOException ignored) {
                return false;
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            return ListDevicesCommandHandler.writeFailResponse(stream, "Failed to retrieve the list of devices from the server.");
        }
        return true;
    }
}

