/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class JdwpDdmsPacket {
    private static final int JDWP_DDMS_HEADER_LENGTH = 19;
    private static final byte IS_RESPONSE_FLAG = -128;
    public static final byte DDMS_CMD_SET = -57;
    public static final byte DDMS_CMD = 1;
    private final int myId;
    private final boolean myIsResponse;
    private final short myErrorCode;
    private final int myChunkType;
    private final byte[] myPayload;

    public static JdwpDdmsPacket readFrom(InputStream iStream) throws IOException {
        byte[] packetHeader = new byte[19];
        int readCount = iStream.read(packetHeader);
        assert (19 == readCount);
        ByteBuffer headerBuffer = ByteBuffer.wrap(packetHeader);
        int length = headerBuffer.getInt();
        int id = headerBuffer.getInt();
        byte flags = headerBuffer.get();
        byte commandSet = headerBuffer.get();
        byte command = headerBuffer.get();
        int chunkType = headerBuffer.getInt();
        int chunkLength = headerBuffer.getInt();
        assert (length >= 19);
        assert (commandSet == -57);
        assert (command == 1);
        assert ((flags & 0x7F) == 0);
        assert (chunkLength == length - 19);
        byte[] payload = new byte[chunkLength];
        if (chunkLength > 0) {
            readCount = iStream.read(payload);
            assert (payload.length == readCount);
        }
        return new JdwpDdmsPacket(id, JdwpDdmsPacket.isResponse(flags), 0, chunkType, payload);
    }

    public static JdwpDdmsPacket createResponse(int id, int chunkType, byte[] payload) {
        return new JdwpDdmsPacket(id, true, 0, chunkType, payload);
    }

    public static JdwpDdmsPacket create(int chunkType, byte[] payload) {
        return new JdwpDdmsPacket(1234, false, 0, chunkType, payload);
    }

    private JdwpDdmsPacket(int id, boolean isResponse, short errorCode, int chunkType, byte[] payload) {
        this.myId = id;
        this.myIsResponse = isResponse;
        this.myErrorCode = errorCode;
        this.myChunkType = chunkType;
        this.myPayload = payload;
    }

    public int getChunkType() {
        return this.myChunkType;
    }

    public int getId() {
        return this.myId;
    }

    public void write(OutputStream oStream) throws IOException {
        byte[] response = new byte[19 + this.myPayload.length];
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        responseBuffer.putInt(response.length);
        responseBuffer.putInt(this.myId);
        responseBuffer.put(this.myIsResponse ? (byte)-128 : 0);
        if (this.myIsResponse) {
            responseBuffer.putShort(this.myErrorCode);
        } else {
            responseBuffer.put((byte)-57);
            responseBuffer.put((byte)1);
        }
        responseBuffer.putInt(this.myChunkType);
        responseBuffer.putInt(this.myPayload.length);
        responseBuffer.put(this.myPayload);
        oStream.write(response);
    }

    private static boolean isResponse(byte flags) {
        return (flags & 0xFFFFFF80) != 0;
    }

    protected static int encodeChunkType(String typeName) {
        assert (typeName.length() == 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= (byte)typeName.charAt(i);
        }
        return val;
    }
}

