/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.DdmUiPreferences;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Addr2Line {
    private static final String ANDROID_SYMBOLS_ENVVAR = "ANDROID_SYMBOLS";
    private static final String LIBRARY_NOT_FOUND_MESSAGE_FORMAT = "Unable to locate library %s on disk. Addresses mapping to this library will not be resolved. In order to fix this, set the the library search path in the UI, or set the environment variable ANDROID_SYMBOLS.";
    private static final HashMap<String, Addr2Line> sProcessCache = new HashMap();
    private static final byte[] sCrLf = new byte[]{10};
    private NativeLibraryMapInfo mLibrary;
    private String mAddr2LineCmd;
    private Process mProcess;
    private BufferedReader mResultReader;
    private BufferedOutputStream mAddressWriter;
    private static final String DEFAULT_LIBRARY_SYMBOLS_FOLDER;
    private static List<String> mLibrarySearchPaths;

    public static void setSearchPath(String path) {
        mLibrarySearchPaths.clear();
        mLibrarySearchPaths.addAll(Arrays.asList(path.split(":")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Addr2Line getProcess(NativeLibraryMapInfo library, String abi) {
        String libName = library.getLibraryName();
        if (libName != null) {
            HashMap<String, Addr2Line> hashMap = sProcessCache;
            synchronized (hashMap) {
                Addr2Line process = sProcessCache.get(libName);
                if (process == null) {
                    process = new Addr2Line(library, abi);
                    boolean status = process.start();
                    if (status) {
                        sProcessCache.put(libName, process);
                    } else {
                        process = null;
                    }
                }
                return process;
            }
        }
        return null;
    }

    private Addr2Line(NativeLibraryMapInfo library, String abi) {
        this.mLibrary = library;
        if (abi == null || abi.startsWith("32")) {
            Log.d((String)"ddm-Addr2Line", (String)"Using 32 bit addr2line command");
            this.mAddr2LineCmd = System.getenv("ANDROID_ADDR2LINE");
            if (this.mAddr2LineCmd == null) {
                this.mAddr2LineCmd = DdmUiPreferences.getAddr2Line();
            }
        } else {
            Log.d((String)"ddm-Addr2Line", (String)"Using 64 bit addr2line command");
            this.mAddr2LineCmd = System.getenv("ANDROID_ADDR2LINE64");
            if (this.mAddr2LineCmd == null) {
                this.mAddr2LineCmd = DdmUiPreferences.getAddr2Line64();
            }
        }
    }

    private String getLibraryPath(String library) {
        String path = DEFAULT_LIBRARY_SYMBOLS_FOLDER + library;
        if (new File(path).exists()) {
            return path;
        }
        for (String p : mLibrarySearchPaths) {
            String fullPath = p + "/" + library;
            if (new File(fullPath).exists()) {
                return fullPath;
            }
            fullPath = p + "/" + new File(library).getName();
            if (!new File(fullPath).exists()) continue;
            return fullPath;
        }
        return null;
    }

    private boolean start() {
        block5: {
            String[] command = new String[5];
            command[0] = this.mAddr2LineCmd;
            command[1] = "-C";
            command[2] = "-f";
            command[3] = "-e";
            String fullPath = this.getLibraryPath(this.mLibrary.getLibraryName());
            if (fullPath == null) {
                String msg = String.format(LIBRARY_NOT_FOUND_MESSAGE_FORMAT, this.mLibrary.getLibraryName());
                Log.e((String)"ddm-Addr2Line", (String)msg);
                return false;
            }
            command[4] = fullPath;
            try {
                this.mProcess = Runtime.getRuntime().exec(command);
                if (this.mProcess != null) {
                    InputStreamReader is = new InputStreamReader(this.mProcess.getInputStream());
                    this.mResultReader = new BufferedReader(is);
                    this.mAddressWriter = new BufferedOutputStream(this.mProcess.getOutputStream());
                    if (this.mResultReader == null || this.mAddressWriter == null) {
                        this.mProcess.destroy();
                        this.mProcess = null;
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException e) {
                String msg = String.format("Error while trying to start %1$s process for library %2$s", this.mAddr2LineCmd, this.mLibrary);
                Log.e((String)"ddm-Addr2Line", (String)msg);
                if (this.mProcess == null) break block5;
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                sProcessCache.remove(this.mLibrary);
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            Collection<Addr2Line> col = sProcessCache.values();
            for (Addr2Line a2l : col) {
                a2l.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeStackCallInfo getAddress(long addr) {
        long offset = addr - this.mLibrary.getStartAddress();
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                String tmp = Long.toString(offset, 16);
                try {
                    this.mAddressWriter.write(tmp.getBytes());
                    this.mAddressWriter.write(sCrLf);
                    this.mAddressWriter.flush();
                    String method = this.mResultReader.readLine();
                    String source = this.mResultReader.readLine();
                    if (method != null && source != null) {
                        return new NativeStackCallInfo(addr, this.mLibrary.getLibraryName(), method, source);
                    }
                }
                catch (IOException e) {
                    Log.e((String)"ddms", (String)("Error while trying to get information for addr: " + tmp + " in library: " + this.mLibrary));
                }
            }
        }
        return null;
    }

    static {
        String symbols = System.getenv(ANDROID_SYMBOLS_ENVVAR);
        DEFAULT_LIBRARY_SYMBOLS_FOLDER = symbols == null ? DdmUiPreferences.getSymbolDirectory() : symbols;
        mLibrarySearchPaths = new ArrayList<String>();
    }
}

