/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.StringHelperPOSIX;
import com.android.utils.StringHelperWindows;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class StringHelper {
    private static final CharMatcher CR = CharMatcher.is((char)'\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
    }

    public static String combineAsCamelCase(Iterable<String> stringList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            sb.append(StringHelper.capitalize(str));
        }
        return sb.toString();
    }

    public static List<String> toStrings(Object ... objects) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add((Object)((String)path));
                continue;
            }
            if (path instanceof Collection) {
                Collection pathCollection = (Collection)path;
                for (Object item : pathCollection) {
                    if (item instanceof String) {
                        builder.add((Object)((String)item));
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        return builder.build();
    }

    public static void appendCamelCase(StringBuilder sb, String word) {
        if (word != null) {
            if (sb.length() == 0) {
                sb.append(word);
            } else {
                sb.append(StringHelper.capitalize(word));
            }
        }
    }

    public static String quoteAndJoinTokens(List<String> tokens) {
        if (SdkConstants.currentPlatform() == 2) {
            return StringHelperWindows.quoteAndJoinTokens(tokens);
        }
        return StringHelperPOSIX.quoteAndJoinTokens(tokens);
    }

    public static List<String> tokenizeString(String string) {
        if (SdkConstants.currentPlatform() == 2) {
            return StringHelperWindows.tokenizeString(string);
        }
        return StringHelperPOSIX.tokenizeString(string);
    }

    public static String toSystemLineSeparator(String input) {
        return StringHelper.toLineSeparator(System.lineSeparator(), input);
    }

    private static String toLineSeparator(String separator, String input) {
        String unixStyle = CR.matchesAnyOf((CharSequence)input) ? CR.removeFrom((CharSequence)input) : input;
        return separator.equals("\n") ? unixStyle : LF.matcher(unixStyle).replaceAll("\r\n");
    }
}

