/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.json;


/**
 * Parses a JSON (<a href="http://www.ietf.org/rfc/rfc4627.txt">RFC 4627</a>)
 * encoded string into the corresponding object. Most clients of
 * this class will use only need the {@link #JSONTokener(java.lang.String) constructor}
 * and {@link #nextValue} method. Example usage: <pre>
 * String json = "{"
 *         + "  \"query\": \"Pizza\", "
 *         + "  \"locations\": [ 94043, 90210 ] "
 *         + "}";
 *
 * JSONObject object = (JSONObject) new JSONTokener(json).nextValue();
 * String query = object.getString("query");
 * JSONArray locations = object.getJSONArray("locations");</pre>
 *
 * <p>For best interoperability and performance use JSON that complies with
 * RFC 4627, such as that generated by {@link org.json.JSONStringer JSONStringer}. For legacy reasons
 * this parser is lenient, so a successful parse does not indicate that the
 * input string was valid JSON. All of the following syntax errors will be
 * ignored:
 * <ul>
 *   <li>End of line comments starting with {@code //} or {@code #} and ending
 *       with a newline character.
 *   <li>C-style comments starting with {@code /*} and ending with
 *       {@code *}{@code /}. Such comments may not be nested.
 *   <li>Strings that are unquoted or {@code 'single quoted'}.
 *   <li>Hexadecimal integers prefixed with {@code 0x} or {@code 0X}.
 *   <li>Octal integers prefixed with {@code 0}.
 *   <li>Array elements separated by {@code ;}.
 *   <li>Unnecessary array separators. These are interpreted as if null was the
 *       omitted value.
 *   <li>Key-value pairs separated by {@code =} or {@code =>}.
 *   <li>Key-value pairs separated by {@code ;}.
 * </ul>
 *
 * <p>Each tokener may be used to parse a single JSON string. Instances of this
 * class are not thread safe. Although this class is nonfinal, it was not
 * designed for inheritance and should not be subclassed. In particular,
 * self-use by overrideable methods is not specified. See <i>Effective Java</i>
 * Item 17, "Design and Document or inheritance or else prohibit it" for further
 * information.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class JSONTokener {

/**
 * @param in JSON encoded string. Null is not permitted and will yield a
 *     tokener that throws {@code NullPointerExceptions} when methods are
 *     called.
 */

public JSONTokener(java.lang.String in) { throw new RuntimeException("Stub!"); }

/**
 * Returns the next value from the input.
 *
 * @return a {@link org.json.JSONObject JSONObject}, {@link org.json.JSONArray JSONArray}, String, Boolean,
 *     Integer, Long, Double or {@link org.json.JSONObject#NULL JSONObject#NULL}.
 * @throws org.json.JSONException if the input is malformed.
 */

public java.lang.Object nextValue() throws org.json.JSONException { throw new RuntimeException("Stub!"); }

/**
 * Returns the string up to but not including {@code quote}, unescaping any
 * character escape sequences encountered along the way. The opening quote
 * should have already been read. This consumes the closing quote, but does
 * not include it in the returned string.
 *
 * @param quote either ' or ".
 */

public java.lang.String nextString(char quote) throws org.json.JSONException { throw new RuntimeException("Stub!"); }

/**
 * Returns an exception containing the given message plus the current
 * position and the entire input string.
 */

public org.json.JSONException syntaxError(java.lang.String message) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current position and the entire input string.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Returns true until the input has been exhausted.
 */

public boolean more() { throw new RuntimeException("Stub!"); }

/**
 * Returns the next available character, or the null character '\0' if all
 * input has been exhausted. The return value of this method is ambiguous
 * for JSON strings that contain the character '\0'.
 */

public char next() { throw new RuntimeException("Stub!"); }

/**
 * Returns the next available character if it equals {@code c}. Otherwise an
 * exception is thrown.
 */

public char next(char c) throws org.json.JSONException { throw new RuntimeException("Stub!"); }

/**
 * Returns the next character that is not whitespace and does not belong to
 * a comment. If the input is exhausted before such a character can be
 * found, the null character '\0' is returned. The return value of this
 * method is ambiguous for JSON strings that contain the character '\0'.
 */

public char nextClean() throws org.json.JSONException { throw new RuntimeException("Stub!"); }

/**
 * Returns the next {@code length} characters of the input.
 *
 * @throws org.json.JSONException if the remaining input is not long enough to
 *     satisfy this request.
 */

public java.lang.String next(int length) throws org.json.JSONException { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link java.lang.String#trim trimmed} string holding the characters up
 * to but not including the first of:
 * <ul>
 *   <li>any character in {@code excluded}
 *   <li>a newline character '\n'
 *   <li>a carriage return '\r'
 * </ul>
 *
 * @return a possibly-empty string
 */

public java.lang.String nextTo(java.lang.String excluded) { throw new RuntimeException("Stub!"); }

/**
 * Equivalent to {@code nextTo(String.valueOf(excluded))}.
 */

public java.lang.String nextTo(char excluded) { throw new RuntimeException("Stub!"); }

/**
 * Advances past all input up to and including the next occurrence of
 * {@code thru}. If the remaining input doesn't contain {@code thru}, the
 * input is exhausted.
 */

public void skipPast(java.lang.String thru) { throw new RuntimeException("Stub!"); }

/**
 * Advances past all input up to but not including the next occurrence of
 * {@code to}. If the remaining input doesn't contain {@code to}, the input
 * is unchanged.
 */

public char skipTo(char to) { throw new RuntimeException("Stub!"); }

/**
 * Unreads the most recent character of input. If no input characters have
 * been read, the input is unchanged.
 */

public void back() { throw new RuntimeException("Stub!"); }

/**
 * Returns the integer [0..15] value for the given hex character, or -1
 * for non-hex input.
 *
 * @param hex a character in the ranges [0-9], [A-F] or [a-f]. Any other
 *     character will yield a -1 result.
 */

public static int dehexchar(char hex) { throw new RuntimeException("Stub!"); }
}

