/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.inputmethod;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface InputConnection {

@android.annotation.Nullable
public java.lang.CharSequence getTextBeforeCursor(int n, int flags);

@android.annotation.Nullable
public java.lang.CharSequence getTextAfterCursor(int n, int flags);

public java.lang.CharSequence getSelectedText(int flags);

@android.annotation.Nullable
public default android.view.inputmethod.SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) { throw new RuntimeException("Stub!"); }

public int getCursorCapsMode(int reqModes);

public android.view.inputmethod.ExtractedText getExtractedText(android.view.inputmethod.ExtractedTextRequest request, int flags);

public boolean deleteSurroundingText(int beforeLength, int afterLength);

public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength);

public boolean setComposingText(java.lang.CharSequence text, int newCursorPosition);

public default boolean setComposingText(@android.annotation.NonNull java.lang.CharSequence text, int newCursorPosition, @android.annotation.Nullable android.view.inputmethod.TextAttribute textAttribute) { throw new RuntimeException("Stub!"); }

public boolean setComposingRegion(int start, int end);

public default boolean setComposingRegion(int start, int end, @android.annotation.Nullable android.view.inputmethod.TextAttribute textAttribute) { throw new RuntimeException("Stub!"); }

public boolean finishComposingText();

public boolean commitText(java.lang.CharSequence text, int newCursorPosition);

public default boolean commitText(@android.annotation.NonNull java.lang.CharSequence text, int newCursorPosition, @android.annotation.Nullable android.view.inputmethod.TextAttribute textAttribute) { throw new RuntimeException("Stub!"); }

public boolean commitCompletion(android.view.inputmethod.CompletionInfo text);

public boolean commitCorrection(android.view.inputmethod.CorrectionInfo correctionInfo);

public boolean setSelection(int start, int end);

public boolean performEditorAction(int editorAction);

public boolean performContextMenuAction(int id);

public boolean beginBatchEdit();

public boolean endBatchEdit();

public boolean sendKeyEvent(android.view.KeyEvent event);

public boolean clearMetaKeyStates(int states);

public boolean reportFullscreenMode(boolean enabled);

public default boolean performSpellCheck() { throw new RuntimeException("Stub!"); }

public boolean performPrivateCommand(java.lang.String action, android.os.Bundle data);

public default void performHandwritingGesture(@android.annotation.NonNull android.view.inputmethod.HandwritingGesture gesture, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable java.util.function.IntConsumer consumer) { throw new RuntimeException("Stub!"); }

public default boolean previewHandwritingGesture(@android.annotation.NonNull android.view.inputmethod.PreviewableHandwritingGesture gesture, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

public boolean requestCursorUpdates(int cursorUpdateMode);

public default boolean requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter) { throw new RuntimeException("Stub!"); }

public default void requestTextBoundsInfo(@android.annotation.NonNull android.graphics.RectF bounds, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.view.inputmethod.TextBoundsInfoResult> consumer) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Handler getHandler();

public void closeConnection();

public boolean commitContent(@android.annotation.NonNull android.view.inputmethod.InputContentInfo inputContentInfo, int flags, @android.annotation.Nullable android.os.Bundle opts);

public default boolean setImeConsumesInput(boolean imeConsumesInput) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.view.inputmethod.TextSnapshot takeSnapshot() { throw new RuntimeException("Stub!"); }

public default boolean replaceText(int start, int end, @android.annotation.NonNull java.lang.CharSequence text, int newCursorPosition, @android.annotation.Nullable android.view.inputmethod.TextAttribute textAttribute) { throw new RuntimeException("Stub!"); }

public static final int CURSOR_UPDATE_FILTER_CHARACTER_BOUNDS = 8; // 0x8

public static final int CURSOR_UPDATE_FILTER_EDITOR_BOUNDS = 4; // 0x4

public static final int CURSOR_UPDATE_FILTER_INSERTION_MARKER = 16; // 0x10

public static final int CURSOR_UPDATE_FILTER_TEXT_APPEARANCE = 64; // 0x40

public static final int CURSOR_UPDATE_FILTER_VISIBLE_LINE_BOUNDS = 32; // 0x20

public static final int CURSOR_UPDATE_IMMEDIATE = 1; // 0x1

public static final int CURSOR_UPDATE_MONITOR = 2; // 0x2

public static final int GET_EXTRACTED_TEXT_MONITOR = 1; // 0x1

public static final int GET_TEXT_WITH_STYLES = 1; // 0x1

public static final int HANDWRITING_GESTURE_RESULT_CANCELLED = 4; // 0x4

public static final int HANDWRITING_GESTURE_RESULT_FAILED = 3; // 0x3

public static final int HANDWRITING_GESTURE_RESULT_FALLBACK = 5; // 0x5

public static final int HANDWRITING_GESTURE_RESULT_SUCCESS = 1; // 0x1

public static final int HANDWRITING_GESTURE_RESULT_UNKNOWN = 0; // 0x0

public static final int HANDWRITING_GESTURE_RESULT_UNSUPPORTED = 2; // 0x2

public static final int INPUT_CONTENT_GRANT_READ_URI_PERMISSION = 1; // 0x1
}

