/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.telephony.euicc;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class EuiccManager {

EuiccManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.telephony.euicc.EuiccManager createForCardId(int cardId) { throw new RuntimeException("Stub!"); }

public boolean isEnabled() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getEid() { throw new RuntimeException("Stub!"); }

public long getAvailableMemoryInBytes() { throw new RuntimeException("Stub!"); }

public void downloadSubscription(android.telephony.euicc.DownloadableSubscription subscription, boolean switchAfterDownload, android.app.PendingIntent callbackIntent) { throw new RuntimeException("Stub!"); }

public void startResolutionActivity(android.app.Activity activity, int requestCode, android.content.Intent resultIntent, android.app.PendingIntent callbackIntent) throws android.content.IntentSender.SendIntentException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.euicc.EuiccInfo getEuiccInfo() { throw new RuntimeException("Stub!"); }

public void deleteSubscription(int subscriptionId, android.app.PendingIntent callbackIntent) { throw new RuntimeException("Stub!"); }

public void switchToSubscription(int subscriptionId, android.app.PendingIntent callbackIntent) { throw new RuntimeException("Stub!"); }

public void switchToSubscription(int subscriptionId, int portIndex, @android.annotation.NonNull android.app.PendingIntent callbackIntent) { throw new RuntimeException("Stub!"); }

public void updateSubscriptionNickname(int subscriptionId, @android.annotation.Nullable java.lang.String nickname, @android.annotation.NonNull android.app.PendingIntent callbackIntent) { throw new RuntimeException("Stub!"); }

public boolean isSimPortAvailable(int portIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_MANAGE_EMBEDDED_SUBSCRIPTIONS = "android.telephony.euicc.action.MANAGE_EMBEDDED_SUBSCRIPTIONS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_NOTIFY_CARRIER_SETUP_INCOMPLETE = "android.telephony.euicc.action.NOTIFY_CARRIER_SETUP_INCOMPLETE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_START_EUICC_ACTIVATION = "android.telephony.euicc.action.START_EUICC_ACTIVATION";

public static final int EMBEDDED_SUBSCRIPTION_RESULT_ERROR = 2; // 0x2

public static final int EMBEDDED_SUBSCRIPTION_RESULT_OK = 0; // 0x0

public static final int EMBEDDED_SUBSCRIPTION_RESULT_RESOLVABLE_ERROR = 1; // 0x1

public static final int ERROR_ADDRESS_MISSING = 10011; // 0x271b

public static final int ERROR_CARRIER_LOCKED = 10000; // 0x2710

public static final int ERROR_CERTIFICATE_ERROR = 10012; // 0x271c

public static final int ERROR_CONNECTION_ERROR = 10014; // 0x271e

public static final int ERROR_DISALLOWED_BY_PPR = 10010; // 0x271a

public static final int ERROR_EUICC_INSUFFICIENT_MEMORY = 10004; // 0x2714

public static final int ERROR_EUICC_MISSING = 10006; // 0x2716

public static final int ERROR_INCOMPATIBLE_CARRIER = 10003; // 0x2713

public static final int ERROR_INSTALL_PROFILE = 10009; // 0x2719

public static final int ERROR_INVALID_ACTIVATION_CODE = 10001; // 0x2711

public static final int ERROR_INVALID_CONFIRMATION_CODE = 10002; // 0x2712

public static final int ERROR_INVALID_PORT = 10017; // 0x2721

public static final int ERROR_INVALID_RESPONSE = 10015; // 0x271f

public static final int ERROR_NO_PROFILES_AVAILABLE = 10013; // 0x271d

public static final int ERROR_OPERATION_BUSY = 10016; // 0x2720

public static final int ERROR_SIM_MISSING = 10008; // 0x2718

public static final int ERROR_TIME_OUT = 10005; // 0x2715

public static final int ERROR_UNSUPPORTED_VERSION = 10007; // 0x2717

public static final long EUICC_MEMORY_FIELD_UNAVAILABLE = -1L; // 0xffffffffffffffffL

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_DETAILED_CODE = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE";

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION";

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_ERROR_CODE = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_ERROR_CODE";

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_OPERATION_CODE = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_OPERATION_CODE";

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_SMDX_REASON_CODE = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_SMDX_REASON_CODE";

public static final java.lang.String EXTRA_EMBEDDED_SUBSCRIPTION_SMDX_SUBJECT_CODE = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_SMDX_SUBJECT_CODE";

public static final java.lang.String EXTRA_USE_QR_SCANNER = "android.telephony.euicc.extra.USE_QR_SCANNER";

public static final java.lang.String META_DATA_CARRIER_ICON = "android.telephony.euicc.carriericon";

public static final int OPERATION_APDU = 8; // 0x8

public static final int OPERATION_DOWNLOAD = 5; // 0x5

public static final int OPERATION_EUICC_CARD = 3; // 0x3

public static final int OPERATION_EUICC_GSMA = 7; // 0x7

public static final int OPERATION_HTTP = 11; // 0xb

public static final int OPERATION_METADATA = 6; // 0x6

public static final int OPERATION_SIM_SLOT = 2; // 0x2

public static final int OPERATION_SMDX = 9; // 0x9

public static final int OPERATION_SMDX_SUBJECT_REASON_CODE = 10; // 0xa

public static final int OPERATION_SWITCH = 4; // 0x4

public static final int OPERATION_SYSTEM = 1; // 0x1
}

