/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.speech;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface RecognitionListener {

public void onReadyForSpeech(android.os.Bundle params);

public void onBeginningOfSpeech();

public void onRmsChanged(float rmsdB);

public void onBufferReceived(byte[] buffer);

public void onEndOfSpeech();

public void onError(int error);

public void onResults(android.os.Bundle results);

public void onPartialResults(android.os.Bundle partialResults);

public default void onSegmentResults(@android.annotation.NonNull android.os.Bundle segmentResults) { throw new RuntimeException("Stub!"); }

public default void onEndOfSegmentedSession() { throw new RuntimeException("Stub!"); }

public default void onLanguageDetection(@android.annotation.NonNull android.os.Bundle results) { throw new RuntimeException("Stub!"); }

public void onEvent(int eventType, android.os.Bundle params);
}

