/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os;


/**
 * Encapsulates results of a single profiling request operation.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ProfilingResult implements android.os.Parcelable {

ProfilingResult() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * The result ErrorCode for the profiling request indicating the failure reason if applicable.

 * @return Value is {@link android.os.ProfilingResult#ERROR_NONE}, {@link android.os.ProfilingResult#ERROR_FAILED_RATE_LIMIT_SYSTEM}, {@link android.os.ProfilingResult#ERROR_FAILED_RATE_LIMIT_PROCESS}, {@link android.os.ProfilingResult#ERROR_FAILED_PROFILING_IN_PROGRESS}, {@link android.os.ProfilingResult#ERROR_FAILED_EXECUTING}, {@link android.os.ProfilingResult#ERROR_FAILED_POST_PROCESSING}, {@link android.os.ProfilingResult#ERROR_FAILED_NO_DISK_SPACE}, or {@link android.os.ProfilingResult#ERROR_UNKNOWN}
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * The file path of the profiling result data.
 *
 * Will be null if {@see #getErrorCode} returns code other than {@see #ERROR_NONE}.
 */

@android.annotation.Nullable
public java.lang.String getResultFilePath() { throw new RuntimeException("Stub!"); }

/**
 * The tag defined by the caller at request time.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getTag() { throw new RuntimeException("Stub!"); }

/**
 * Additional details about failures that occurred, if applicable.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getErrorMessage() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.os.ProfilingResult> CREATOR;
static { CREATOR = null; }

/** The request was executed and failed for a reason not specified below. */

public static final int ERROR_FAILED_EXECUTING = 4; // 0x4

/** The request failed due to invalid ProfilingRequest. */

public static final int ERROR_FAILED_INVALID_REQUEST = 7; // 0x7

/** The request was executed and failed due to a lack of disk space. */

public static final int ERROR_FAILED_NO_DISK_SPACE = 6; // 0x6

/** The request was executed but post processing failed and the result was discarded. */

public static final int ERROR_FAILED_POST_PROCESSING = 5; // 0x5

/** The request was denied due to profiling already in progress. */

public static final int ERROR_FAILED_PROFILING_IN_PROGRESS = 3; // 0x3

/** The request was denied due to process level rate limiting. */

public static final int ERROR_FAILED_RATE_LIMIT_PROCESS = 2; // 0x2

/** The request was denied due to system level rate limiting. */

public static final int ERROR_FAILED_RATE_LIMIT_SYSTEM = 1; // 0x1

/** The request was executed and succeeded. */

public static final int ERROR_NONE = 0; // 0x0

/** The request was denied or failed for an unspecified reason. */

public static final int ERROR_UNKNOWN = 8; // 0x8
}

