/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;


/**
 * Configuration for a soft access point (a.k.a. Soft AP, SAP, Hotspot).
 *
 * <p>This is input for the framework provided by a client app, i.e. it exposes knobs to instruct
 * the framework how it should configure a hotspot.
 *
 * <p>System apps can use this to configure a tethered hotspot or local-only hotspot.
 *
 * <p>Instances of this class are immutable.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SoftApConfiguration implements android.os.Parcelable {

SoftApConfiguration() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object otherObj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Return the UTF-8 String set to be the SSID for the AP. If the SSID cannot be decoded as
 * UTF-8, then this will return {@link android.net.wifi.WifiManager#UNKNOWN_SSID WifiManager#UNKNOWN_SSID}.
 *
 * @deprecated Use {@link #getWifiSsid()} instead.

 * @return This value may be {@code null}.
 */

@Deprecated
@android.annotation.Nullable
public java.lang.String getSsid() { throw new RuntimeException("Stub!"); }

/**
 * Return WifiSsid set to be the SSID for the AP.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.WifiSsid getWifiSsid() { throw new RuntimeException("Stub!"); }

/**
 * Returns MAC address set to be BSSID for the AP.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.MacAddress getBssid() { throw new RuntimeException("Stub!"); }

/**
 * Returns String set to be passphrase for current AP.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getPassphrase() { throw new RuntimeException("Stub!"); }

/**
 * Returns Boolean set to be indicate hidden (true: doesn't broadcast its SSID) or
 * not (false: broadcasts its SSID) for the AP.
 */

public boolean isHiddenSsid() { throw new RuntimeException("Stub!"); }

/**
 * Get security type params which depends on which security passphrase to set.
 *
 * @return One of:
 * {@link #SECURITY_TYPE_OPEN},
 * {@link #SECURITY_TYPE_WPA2_PSK},
 * {@link #SECURITY_TYPE_WPA3_SAE_TRANSITION},
 * {@link #SECURITY_TYPE_WPA3_SAE},
 * {@link #SECURITY_TYPE_WPA3_OWE_TRANSITION},
 * {@link #SECURITY_TYPE_WPA3_OWE}

 * Value is {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_OPEN}, {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_WPA2_PSK}, {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_WPA3_SAE_TRANSITION}, {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_WPA3_SAE}, {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_WPA3_OWE_TRANSITION}, or {@link android.net.wifi.SoftApConfiguration#SECURITY_TYPE_WPA3_OWE}
 */

public int getSecurityType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.SoftApConfiguration> CREATOR;
static { CREATOR = null; }

/**
 * THe definition of security type OPEN.
 */

public static final int SECURITY_TYPE_OPEN = 0; // 0x0

/**
 * The definition of security type WPA2-PSK.
 */

public static final int SECURITY_TYPE_WPA2_PSK = 1; // 0x1

/**
 * The definition of security type WPA3-OWE.
 */

public static final int SECURITY_TYPE_WPA3_OWE = 5; // 0x5

/**
 * The definition of security type WPA3-OWE Transition.
 */

public static final int SECURITY_TYPE_WPA3_OWE_TRANSITION = 4; // 0x4

/**
 * The definition of security type WPA3-SAE.
 */

public static final int SECURITY_TYPE_WPA3_SAE = 3; // 0x3

/**
 * The definition of security type WPA3-SAE Transition mode.
 */

public static final int SECURITY_TYPE_WPA3_SAE_TRANSITION = 2; // 0x2
}

