/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaRouter2 {

MediaRouter2() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaRouter2 getInstance(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaRouter2 getInstance(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String clientPackageName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.lang.Runnable onInstanceInvalidatedListener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRouter2.ScanToken requestScan(@android.annotation.NonNull android.media.MediaRouter2.ScanRequest scanRequest) { throw new RuntimeException("Stub!"); }

public void cancelScanRequest(@android.annotation.NonNull android.media.MediaRouter2.ScanToken token) { throw new RuntimeException("Stub!"); }

public void registerRouteCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaRouter2.RouteCallback routeCallback, @android.annotation.NonNull android.media.RouteDiscoveryPreference preference) { throw new RuntimeException("Stub!"); }

public void unregisterRouteCallback(@android.annotation.NonNull android.media.MediaRouter2.RouteCallback routeCallback) { throw new RuntimeException("Stub!"); }

public void registerRouteListingPreferenceUpdatedCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.media.RouteListingPreference> routeListingPreferenceCallback) { throw new RuntimeException("Stub!"); }

public void unregisterRouteListingPreferenceUpdatedCallback(@android.annotation.NonNull java.util.function.Consumer<android.media.RouteListingPreference> callback) { throw new RuntimeException("Stub!"); }

public boolean showSystemOutputSwitcher() { throw new RuntimeException("Stub!"); }

public void setRouteListingPreference(@android.annotation.Nullable android.media.RouteListingPreference routeListingPreference) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.RouteListingPreference getRouteListingPreference() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRoute2Info> getRoutes() { throw new RuntimeException("Stub!"); }

public void registerTransferCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaRouter2.TransferCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterTransferCallback(@android.annotation.NonNull android.media.MediaRouter2.TransferCallback callback) { throw new RuntimeException("Stub!"); }

public void registerControllerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaRouter2.ControllerCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterControllerCallback(@android.annotation.NonNull android.media.MediaRouter2.ControllerCallback callback) { throw new RuntimeException("Stub!"); }

public void setOnGetControllerHintsListener(@android.annotation.Nullable android.media.MediaRouter2.OnGetControllerHintsListener listener) { throw new RuntimeException("Stub!"); }

public void transferTo(@android.annotation.NonNull android.media.MediaRoute2Info route) { throw new RuntimeException("Stub!"); }

public void stop() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRouter2.RoutingController getSystemController() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaRouter2.RoutingController getController(@android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRouter2.RoutingController> getControllers() { throw new RuntimeException("Stub!"); }

public void setRouteVolume(@android.annotation.NonNull android.media.MediaRoute2Info route, int volume) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class ControllerCallback {

public ControllerCallback() { throw new RuntimeException("Stub!"); }

public void onControllerUpdated(@android.annotation.NonNull android.media.MediaRouter2.RoutingController controller) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnGetControllerHintsListener {

@android.annotation.Nullable
public android.os.Bundle onGetControllerHints(@android.annotation.NonNull android.media.MediaRoute2Info route);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class RouteCallback {

public RouteCallback() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onRoutesAdded(@android.annotation.NonNull java.util.List<android.media.MediaRoute2Info> routes) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onRoutesRemoved(@android.annotation.NonNull java.util.List<android.media.MediaRoute2Info> routes) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onRoutesChanged(@android.annotation.NonNull java.util.List<android.media.MediaRoute2Info> routes) { throw new RuntimeException("Stub!"); }

public void onRoutesUpdated(@android.annotation.NonNull java.util.List<android.media.MediaRoute2Info> routes) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RoutingController {

RoutingController() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getControlHints() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRoute2Info> getSelectedRoutes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRoute2Info> getSelectableRoutes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRoute2Info> getDeselectableRoutes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.MediaRoute2Info> getTransferableRoutes() { throw new RuntimeException("Stub!"); }

public boolean wasTransferInitiatedBySelf() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RoutingSessionInfo getRoutingSessionInfo() { throw new RuntimeException("Stub!"); }

public int getVolumeHandling() { throw new RuntimeException("Stub!"); }

public int getVolumeMax() { throw new RuntimeException("Stub!"); }

public int getVolume() { throw new RuntimeException("Stub!"); }

public boolean isReleased() { throw new RuntimeException("Stub!"); }

public void selectRoute(@android.annotation.NonNull android.media.MediaRoute2Info route) { throw new RuntimeException("Stub!"); }

public void deselectRoute(@android.annotation.NonNull android.media.MediaRoute2Info route) { throw new RuntimeException("Stub!"); }

public void setVolume(int volume) { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ScanRequest {

ScanRequest() { throw new RuntimeException("Stub!"); }

public boolean isScreenOffScan() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRouter2.ScanRequest.Builder setScreenOffScan(boolean isScreenOffScan) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRouter2.ScanRequest build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ScanToken {

ScanToken() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class TransferCallback {

public TransferCallback() { throw new RuntimeException("Stub!"); }

public void onTransfer(@android.annotation.NonNull android.media.MediaRouter2.RoutingController oldController, @android.annotation.NonNull android.media.MediaRouter2.RoutingController newController) { throw new RuntimeException("Stub!"); }

public void onTransferFailure(@android.annotation.NonNull android.media.MediaRoute2Info requestedRoute) { throw new RuntimeException("Stub!"); }

public void onStop(@android.annotation.NonNull android.media.MediaRouter2.RoutingController controller) { throw new RuntimeException("Stub!"); }
}

}

