/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location.provider;


/**
 * Location provider properties.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ProviderProperties implements android.os.Parcelable {

ProviderProperties() { throw new RuntimeException("Stub!"); }

/**
 * True if provider requires access to a data network (e.g., the Internet).
 */

public boolean hasNetworkRequirement() { throw new RuntimeException("Stub!"); }

/**
 * True if the provider requires access to a satellite-based positioning system (e.g., GPS).
 */

public boolean hasSatelliteRequirement() { throw new RuntimeException("Stub!"); }

/**
 * True if the provider requires access to a cellular network (e.g., for cell tower IDs).
 */

public boolean hasCellRequirement() { throw new RuntimeException("Stub!"); }

/**
 * True if this provider may result in a monetary charge to the user. Network usage is not
 * considered a monetary cost.
 */

public boolean hasMonetaryCost() { throw new RuntimeException("Stub!"); }

/**
 * True if the provider is able to provide altitude under at least some conditions.
 */

public boolean hasAltitudeSupport() { throw new RuntimeException("Stub!"); }

/**
 * True if the provider is able to provide speed under at least some conditions.
 */

public boolean hasSpeedSupport() { throw new RuntimeException("Stub!"); }

/**
 * True if the provider is able to provide bearing under at least some conditions.
 */

public boolean hasBearingSupport() { throw new RuntimeException("Stub!"); }

/**
 * Power usage for this provider.

 * @return Value is {@link android.location.provider.ProviderProperties#POWER_USAGE_LOW}, {@link android.location.provider.ProviderProperties#POWER_USAGE_MEDIUM}, or {@link android.location.provider.ProviderProperties#POWER_USAGE_HIGH}
 */

public int getPowerUsage() { throw new RuntimeException("Stub!"); }

/**
 * Rough location accuracy for this provider, primarily with respect to horizontal location
 * accuracy.

 * @return Value is {@link android.location.provider.ProviderProperties#ACCURACY_FINE}, or {@link android.location.provider.ProviderProperties#ACCURACY_COARSE}
 */

public int getAccuracy() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * A constant indicating a coarser location accuracy.
 */

public static final int ACCURACY_COARSE = 2; // 0x2

/**
 * A constant indicating a finer location accuracy.
 */

public static final int ACCURACY_FINE = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.provider.ProviderProperties> CREATOR;
static { CREATOR = null; }

/**
 * A constant indicating high power usage.
 */

public static final int POWER_USAGE_HIGH = 3; // 0x3

/**
 * A constant indicating low power usage.
 */

public static final int POWER_USAGE_LOW = 1; // 0x1

/**
 * A constant indicating a medium power usage.
 */

public static final int POWER_USAGE_MEDIUM = 2; // 0x2
/**
 * Builder for ProviderProperties.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param providerProperties This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.provider.ProviderProperties providerProperties) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider requires network access. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasNetworkRequirement(boolean requiresNetwork) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider requires satellite access. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasSatelliteRequirement(boolean requiresSatellite) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider requires cell tower access. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasCellRequirement(boolean requiresCell) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider has a monetary cost. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasMonetaryCost(boolean monetaryCost) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider can provide altitude information. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasAltitudeSupport(boolean supportsAltitude) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider can provide speed information. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasSpeedSupport(boolean supportsSpeed) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a provider can provide bearing information. False by default.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasBearingSupport(boolean supportsBearing) { throw new RuntimeException("Stub!"); }

/**
 * Sets a very rough bucket of provider power usage. {@link #POWER_USAGE_HIGH} by default.
 
 * @param powerUsage Value is {@link android.location.provider.ProviderProperties#POWER_USAGE_LOW}, {@link android.location.provider.ProviderProperties#POWER_USAGE_MEDIUM}, or {@link android.location.provider.ProviderProperties#POWER_USAGE_HIGH}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setPowerUsage(int powerUsage) { throw new RuntimeException("Stub!"); }

/**
 * Sets a very rough bucket of provider location accuracy. {@link #ACCURACY_COARSE} by
 * default.
 
 * @param accuracy Value is {@link android.location.provider.ProviderProperties#ACCURACY_FINE}, or {@link android.location.provider.ProviderProperties#ACCURACY_COARSE}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new ProviderProperties.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.provider.ProviderProperties build() { throw new RuntimeException("Stub!"); }
}

}

