/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/** Each record represents the result of an ovulation test. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OvulationTestRecord extends android.health.connect.datatypes.InstantRecord {

OvulationTestRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return test result

 * Value is {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_INCONCLUSIVE}, {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_POSITIVE}, {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_HIGH}, or {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_NEGATIVE}
 */

public int getResult() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.OvulationTestRecord OvulationTestRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param result The result of a user's ovulation test, which shows if they're ovulating or
 *     not. Required field. Allowed values: {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult OvulationTestResult}.

 * Value is {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_INCONCLUSIVE}, {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_POSITIVE}, {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_HIGH}, or {@link android.health.connect.datatypes.OvulationTestRecord.OvulationTestResult#RESULT_NEGATIVE}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int result) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OvulationTestRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OvulationTestRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.OvulationTestRecord OvulationTestRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OvulationTestRecord build() { throw new RuntimeException("Stub!"); }
}

/** Identifier for Ovulation Test Result */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class OvulationTestResult {

OvulationTestResult() { throw new RuntimeException("Stub!"); }

/**
 * High fertility. Refers to a rise in estrogen or luteinizing hormone that may signal the
 * fertile window (time in the menstrual cycle when conception is likely to occur).
 */

public static final int RESULT_HIGH = 2; // 0x2

/**
 * Inconclusive result. Refers to ovulation test results that are indeterminate (e.g. may be
 * testing malfunction, user error, etc.). ". Any unknown value will also be returned as
 * [RESULT_INCONCLUSIVE].
 */

public static final int RESULT_INCONCLUSIVE = 0; // 0x0

/**
 * Negative fertility (may also be referred as "low" fertility). Refers to the time in the
 * cycle where fertility/conception is expected to be low.
 */

public static final int RESULT_NEGATIVE = 3; // 0x3

/**
 * Positive fertility (may also be referred as "peak" fertility). Refers to the peak of the
 * luteinizing hormone (LH) surge and ovulation is expected to occur in 10-36 hours.
 */

public static final int RESULT_POSITIVE = 1; // 0x1
}

}

