/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/** A record that contains a measurement with a time interval. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IntervalRecord extends android.health.connect.datatypes.Record {

IntervalRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return Start time of the activity

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getStartTime() { throw new RuntimeException("Stub!"); }

/**
 * @return Start time's zone offset of the activity

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.ZoneOffset getStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return End time of the activity

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * @return End time's zone offset of the activity

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.ZoneOffset getEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
}

