/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * Identifier for exercise types, as returned by {@link android.health.connect.datatypes.ExerciseSessionRecord#getExerciseType() ExerciseSessionRecord#getExerciseType()}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseSessionType {

ExerciseSessionType() { throw new RuntimeException("Stub!"); }

/** Use this type for the badminton playing session. */

public static final int EXERCISE_SESSION_TYPE_BADMINTON = 1; // 0x1

/** Use this type for the baseball playing session. */

public static final int EXERCISE_SESSION_TYPE_BASEBALL = 2; // 0x2

/** Use this type for the basketball playing session. */

public static final int EXERCISE_SESSION_TYPE_BASKETBALL = 3; // 0x3

/** Use this type for riding a bicycle session. */

public static final int EXERCISE_SESSION_TYPE_BIKING = 4; // 0x4

/** Use this type for riding a stationary bicycle session. */

public static final int EXERCISE_SESSION_TYPE_BIKING_STATIONARY = 5; // 0x5

/** Use this type for the boot camp session. */

public static final int EXERCISE_SESSION_TYPE_BOOT_CAMP = 6; // 0x6

/** Use this type for boxing session. */

public static final int EXERCISE_SESSION_TYPE_BOXING = 7; // 0x7

/** Use this type for calisthenics session. */

public static final int EXERCISE_SESSION_TYPE_CALISTHENICS = 8; // 0x8

/** Use this type for the cricket playing session. */

public static final int EXERCISE_SESSION_TYPE_CRICKET = 9; // 0x9

/** Use this type for the dancing session. */

public static final int EXERCISE_SESSION_TYPE_DANCING = 10; // 0xa

/** Use this type for elliptical workout. */

public static final int EXERCISE_SESSION_TYPE_ELLIPTICAL = 60; // 0x3c

/** Use this type for the exercise class session. */

public static final int EXERCISE_SESSION_TYPE_EXERCISE_CLASS = 11; // 0xb

/** Use this type for the fencing session. */

public static final int EXERCISE_SESSION_TYPE_FENCING = 12; // 0xc

/** Use this type for the American football playing session. */

public static final int EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN = 13; // 0xd

/** Use this type for the Australian football playing session. */

public static final int EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN = 14; // 0xe

/** Use this type for the frisbee disc playing session. */

public static final int EXERCISE_SESSION_TYPE_FRISBEE_DISC = 15; // 0xf

/** Use this type for the golf playing session. */

public static final int EXERCISE_SESSION_TYPE_GOLF = 16; // 0x10

/** Use this type for the guided breathing session. */

public static final int EXERCISE_SESSION_TYPE_GUIDED_BREATHING = 17; // 0x11

/** Use this type for the gymnastics session. */

public static final int EXERCISE_SESSION_TYPE_GYMNASTICS = 18; // 0x12

/** Use this type for the handball playing session. */

public static final int EXERCISE_SESSION_TYPE_HANDBALL = 19; // 0x13

/** Use this type for the high intensity interval training session. */

public static final int EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING = 20; // 0x14

/** Use this type for the hiking session. */

public static final int EXERCISE_SESSION_TYPE_HIKING = 21; // 0x15

/** Use this type for the ice hockey playing session. */

public static final int EXERCISE_SESSION_TYPE_ICE_HOCKEY = 22; // 0x16

/** Use this type for the ice skating session. */

public static final int EXERCISE_SESSION_TYPE_ICE_SKATING = 23; // 0x17

/** Use this type for the martial arts training session. */

public static final int EXERCISE_SESSION_TYPE_MARTIAL_ARTS = 24; // 0x18

/** Use this type for the other workout session. */

public static final int EXERCISE_SESSION_TYPE_OTHER_WORKOUT = 58; // 0x3a

/** Use this type for the paddling session. */

public static final int EXERCISE_SESSION_TYPE_PADDLING = 25; // 0x19

/** Use this type for the paragliding session. */

public static final int EXERCISE_SESSION_TYPE_PARAGLIDING = 26; // 0x1a

/** Use this type for the pilates session. */

public static final int EXERCISE_SESSION_TYPE_PILATES = 27; // 0x1b

/** Use this type for the racquetball playing session. */

public static final int EXERCISE_SESSION_TYPE_RACQUETBALL = 28; // 0x1c

/** Use this type for the rock climbing session. */

public static final int EXERCISE_SESSION_TYPE_ROCK_CLIMBING = 29; // 0x1d

/** Use this type for the roller hockey playing session. */

public static final int EXERCISE_SESSION_TYPE_ROLLER_HOCKEY = 30; // 0x1e

/** Use this type for the rowing session. */

public static final int EXERCISE_SESSION_TYPE_ROWING = 31; // 0x1f

/** Use this type for rowing machine. */

public static final int EXERCISE_SESSION_TYPE_ROWING_MACHINE = 61; // 0x3d

/** Use this type for the rugby playing session. */

public static final int EXERCISE_SESSION_TYPE_RUGBY = 32; // 0x20

/** Use this type for the running session. */

public static final int EXERCISE_SESSION_TYPE_RUNNING = 33; // 0x21

/** Use this type for the treadmill running session. */

public static final int EXERCISE_SESSION_TYPE_RUNNING_TREADMILL = 34; // 0x22

/** Use this type for the sailing session. */

public static final int EXERCISE_SESSION_TYPE_SAILING = 35; // 0x23

/** Use this type for the scuba diving session. */

public static final int EXERCISE_SESSION_TYPE_SCUBA_DIVING = 36; // 0x24

/** Use this type for the skating session. */

public static final int EXERCISE_SESSION_TYPE_SKATING = 37; // 0x25

/** Use this type for the skiing session. */

public static final int EXERCISE_SESSION_TYPE_SKIING = 38; // 0x26

/** Use this type for the snowboarding session. */

public static final int EXERCISE_SESSION_TYPE_SNOWBOARDING = 39; // 0x27

/** Use this type for the snowshoeing session. */

public static final int EXERCISE_SESSION_TYPE_SNOWSHOEING = 40; // 0x28

/** Use this type for the soccer playing session. */

public static final int EXERCISE_SESSION_TYPE_SOCCER = 41; // 0x29

/** Use this type for the softball playing session. */

public static final int EXERCISE_SESSION_TYPE_SOFTBALL = 42; // 0x2a

/** Use this type for the squash playing session. */

public static final int EXERCISE_SESSION_TYPE_SQUASH = 43; // 0x2b

/** Use this type for the stair climbing session. */

public static final int EXERCISE_SESSION_TYPE_STAIR_CLIMBING = 44; // 0x2c

/** Use this type for the stair climbing machine session. */

public static final int EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE = 59; // 0x3b

/** Use this type for the strength training session. */

public static final int EXERCISE_SESSION_TYPE_STRENGTH_TRAINING = 45; // 0x2d

/** Use this type for the stretching session. */

public static final int EXERCISE_SESSION_TYPE_STRETCHING = 46; // 0x2e

/** Use this type for the surfing session. */

public static final int EXERCISE_SESSION_TYPE_SURFING = 47; // 0x2f

/** Use this type for the swimming in the open water session. */

public static final int EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER = 48; // 0x30

/** Use this type for the swimming in the pool session. */

public static final int EXERCISE_SESSION_TYPE_SWIMMING_POOL = 49; // 0x31

/** Use this type for the table tennis playing session. */

public static final int EXERCISE_SESSION_TYPE_TABLE_TENNIS = 50; // 0x32

/** Use this type for the tennis playing session. */

public static final int EXERCISE_SESSION_TYPE_TENNIS = 51; // 0x33

/** Use this type if the type of the exercise session is not known. */

public static final int EXERCISE_SESSION_TYPE_UNKNOWN = 0; // 0x0

/** Use this type for the volleyball playing session. */

public static final int EXERCISE_SESSION_TYPE_VOLLEYBALL = 52; // 0x34

/** Use this type for the walking session. */

public static final int EXERCISE_SESSION_TYPE_WALKING = 53; // 0x35

/** Use this type for the water polo playing session. */

public static final int EXERCISE_SESSION_TYPE_WATER_POLO = 54; // 0x36

/** Use this type for the weightlifting session. */

public static final int EXERCISE_SESSION_TYPE_WEIGHTLIFTING = 55; // 0x37

/** Use this type for the wheelchair session. */

public static final int EXERCISE_SESSION_TYPE_WHEELCHAIR = 56; // 0x38

/** Use this type for the yoga session. */

public static final int EXERCISE_SESSION_TYPE_YOGA = 57; // 0x39
}

