/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** A goal which should be met to complete a {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ExerciseCompletionGoal {

ExerciseCompletionGoal() { throw new RuntimeException("Stub!"); }
/**
 * An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires a specified number of active calories to be
 * burned.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ActiveCaloriesBurnedGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param activeCalories The active calories that must be burnt to complete the goal.

 * This value cannot be {@code null}.
 */

public ActiveCaloriesBurnedGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Energy activeCalories) { throw new RuntimeException("Stub!"); }

/**
 * Returns the active calories that must be burned to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Energy getActiveCalories() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires covering a specified distance. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DistanceGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param distance The total distance that must be covered to complete the goal.

 * This value cannot be {@code null}.
 */

public DistanceGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Length distance) { throw new RuntimeException("Stub!"); }

/**
 * Returns the total distance that must be covered to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Length getDistance() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires covering a specified distance. Additionally,
 * the step is not complete until the specified time has elapsed. Time remaining after the
 * specified distance has been completed should be spent resting. In the context of swimming,
 * this is sometimes referred to as 'interval training'.
 *
 * <p>For example, a swimming coach may specify '100m @ 1min40s'. This implies: complete 100m
 * and if you manage it in 1min30s, you will have 10s of rest prior to the next set.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DistanceWithVariableRestGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param distance The total distance that must be covered to complete the goal.
 * This value cannot be {@code null}.
 * @param duration The total duration that must elapse to complete the goal.

 * This value cannot be {@code null}.
 */

public DistanceWithVariableRestGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Length distance, @android.annotation.NonNull java.time.Duration duration) { throw new RuntimeException("Stub!"); }

/**
 * Returns the total distance that must be covered to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Length getDistance() { throw new RuntimeException("Stub!"); }

/**
 * Returns the total duration that must elapse to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getDuration() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires a specified duration to elapse. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DurationGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param duration The total duration that must elapse to complete the goal.

 * This value cannot be {@code null}.
 */

public DurationGoal(@android.annotation.NonNull java.time.Duration duration) { throw new RuntimeException("Stub!"); }

/**
 * Returns the total duration that must elapse to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getDuration() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires a specified number of repetitions to be
 * completed.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RepetitionsGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param repetitions The total repetitions required to complete the goal.
 */

public RepetitionsGoal(int repetitions) { throw new RuntimeException("Stub!"); }

/** Returns the total number of repetitions that must be completed to complete this goal. */

public int getRepetitions() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires completing a specified number of steps. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StepsGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param steps The total steps that must be covered to complete the goal.
 */

public StepsGoal(int steps) { throw new RuntimeException("Stub!"); }

/** Returns the total number of steps that must be completed to complete this goal. */

public int getSteps() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that requires a specified number of total calories to be
 * burned.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TotalCaloriesBurnedGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

/**
 * @param totalCalories The total calories that must be burnt to complete the goal.

 * This value cannot be {@code null}.
 */

public TotalCaloriesBurnedGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Energy totalCalories) { throw new RuntimeException("Stub!"); }

/**
 * Returns the total calories that must be burned to complete this goal.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Energy getTotalCalories() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that is unknown. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class UnknownGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

UnknownGoal() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.ExerciseCompletionGoal.UnknownGoal INSTANCE;
static { INSTANCE = null; }
}

/**
 * An {@link android.health.connect.datatypes.ExerciseCompletionGoal ExerciseCompletionGoal} that has no specific target metric. It is up to the user to
 * determine when the associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep} is complete.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class UnspecifiedGoal extends android.health.connect.datatypes.ExerciseCompletionGoal {

UnspecifiedGoal() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.ExerciseCompletionGoal.UnspecifiedGoal INSTANCE;
static { INSTANCE = null; }
}

}

