/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** Specifies the contributing source/application of any {@link android.health.connect.datatypes.Record Record} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DataOrigin {

DataOrigin() { throw new RuntimeException("Stub!"); }

/**
 * @return the corresponding package name.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * @see android.health.connect.datatypes.DataOrigin
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the package name of the contributing package. Auto-populated by the platform at
 * record insertion time.
 
 * @param packageName This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.DataOrigin.Builder setPackageName(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

/**
 * @return {@link android.health.connect.datatypes.DataOrigin DataOrigin}'s object

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.DataOrigin build() { throw new RuntimeException("Stub!"); }
}

}

