/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;


/**
 * Specification of time range for read and delete requests. Internally represents a SQLLite
 * argument that specifies start and end time to put in as SQLLite parameters. The filter must be
 * bound at least at one of the ends, i.e., either the start or end time must be set, or else an
 * IllegalArgumentException is thrown.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TimeInstantRangeFilter implements android.health.connect.TimeRangeFilter {

TimeInstantRangeFilter() { throw new RuntimeException("Stub!"); }

/**
 * @return start time instant of this filter

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getStartTime() { throw new RuntimeException("Stub!"); }

/**
 * @return end time instant of this filter

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * @return a boolean value indicating if the filter is bound or not.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public boolean isBounded() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.TimeInstantRangeFilter TimeInstantRangeFilter} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param startTime represents start time of this filter
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.TimeInstantRangeFilter.Builder setStartTime(@android.annotation.Nullable java.time.Instant startTime) { throw new RuntimeException("Stub!"); }

/**
 * @param endTime end time of this filter
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.TimeInstantRangeFilter.Builder setEndTime(@android.annotation.Nullable java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Builds {@link android.health.connect.TimeInstantRangeFilter TimeInstantRangeFilter}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.TimeInstantRangeFilter build() { throw new RuntimeException("Stub!"); }
}

}

