/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.Record;

/** A class to represent filtering based on record ID or client ID. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RecordIdFilter {

RecordIdFilter() { throw new RuntimeException("Stub!"); }

/**
 * Creates an instance of Record id filter based on client record id.
 *
 * <p>Note: this only works when reading own records, using client record ids to read
 * records inserted by another app will return no result.
 *
 * @param recordType Record class for which the client record id must be set.
 * This value cannot be {@code null}.
 * @param clientRecordId Client identifier that was set while inserting the record.
 * This value cannot be {@code null}.
 * @return Object of {@link android.health.connect.RecordIdFilter RecordIdFilter}
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.health.connect.RecordIdFilter fromClientRecordId(@android.annotation.NonNull java.lang.Class<? extends android.health.connect.datatypes.Record> recordType, @android.annotation.NonNull java.lang.String clientRecordId) { throw new RuntimeException("Stub!"); }

/**
 * Creates an instance of Record id filter based on record id.
 *
 * @param recordType Record class for which the id must be set.
 * This value cannot be {@code null}.
 * @param id Identifier generated by the platform and returned by {@link android.health.connect.HealthConnectManager#insertRecords      }
 * This value cannot be {@code null}.
 * @return Object of {@link android.health.connect.RecordIdFilter RecordIdFilter}
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.health.connect.RecordIdFilter fromId(@android.annotation.NonNull java.lang.Class<? extends android.health.connect.datatypes.Record> recordType, @android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

/**
 * @return Record class for this identifier

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.Class<? extends android.health.connect.datatypes.Record> getRecordType() { throw new RuntimeException("Stub!"); }

/**
 * @return Identifier given by the platform

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * @return Client record identifier

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getClientRecordId() { throw new RuntimeException("Stub!"); }
}

