/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import java.util.Set;

/** A class to create requests for {@link android.health.connect.HealthConnectManager#aggregate HealthConnectManager#aggregate} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AggregateRecordsRequest<T> {

AggregateRecordsRequest() { throw new RuntimeException("Stub!"); }

/**
 * @return time range b/w which the aggregate operation is to be performed

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.TimeRangeFilter getTimeRangeFilter() { throw new RuntimeException("Stub!"); }

/**
 * @return Set of integers from {@link android.health.connect.datatypes.AggregationType AggregationType} to aggregate

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.health.connect.datatypes.AggregationType<T>> getAggregationTypes() { throw new RuntimeException("Stub!"); }

/**
 * @return Set of {@link android.health.connect.datatypes.DataOrigin DataOrigin}s to read from, or empty set for no filter

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.health.connect.datatypes.DataOrigin> getDataOriginsFilters() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder<T> {

/**
 * @param timeRangeFilter Time range b/w which the aggregate operation is to be performed
 *     <p>Filters applies to all the aggregate requests.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.TimeRangeFilter timeRangeFilter) { throw new RuntimeException("Stub!"); }

/**
 * @param aggregationType {@link android.health.connect.datatypes.AggregationType AggregationType} to aggregate.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.AggregateRecordsRequest.Builder<T> addAggregationType(@android.annotation.NonNull android.health.connect.datatypes.AggregationType<T> aggregationType) { throw new RuntimeException("Stub!"); }

/**
 * Adds {@code dataOriginsFilter} to the set of {@link android.health.connect.datatypes.DataOrigin DataOrigin} to filter for this
 * aggregation.
 *
 * <p>If not set data from all data origins will be considered for this operation
 
 * @param dataOriginsFilter This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.AggregateRecordsRequest.Builder<T> addDataOriginsFilter(@android.annotation.NonNull android.health.connect.datatypes.DataOrigin dataOriginsFilter) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.AggregateRecordsRequest AggregateRecordsRequest}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.AggregateRecordsRequest<T> build() { throw new RuntimeException("Stub!"); }
}

}

