/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.content.pm;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class PackageInstaller {

PackageInstaller() { throw new RuntimeException("Stub!"); }

public int createSession(@android.annotation.NonNull android.content.pm.PackageInstaller.SessionParams params) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.Session openSession(int sessionId) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void updateSessionAppIcon(int sessionId, @android.annotation.Nullable android.graphics.Bitmap appIcon) { throw new RuntimeException("Stub!"); }

public void updateSessionAppLabel(int sessionId, @android.annotation.Nullable java.lang.CharSequence appLabel) { throw new RuntimeException("Stub!"); }

public void abandonSession(int sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.pm.PackageInstaller.SessionInfo getSessionInfo(int sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInstaller.SessionInfo> getAllSessions() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInstaller.SessionInfo> getMySessions() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInstaller.SessionInfo> getStagedSessions() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.content.pm.PackageInstaller.SessionInfo getActiveStagedSession() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInstaller.SessionInfo> getActiveStagedSessions() { throw new RuntimeException("Stub!"); }

public void uninstall(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void uninstall(@android.annotation.NonNull android.content.pm.VersionedPackage versionedPackage, @android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void uninstall(@android.annotation.NonNull android.content.pm.VersionedPackage versionedPackage, int flags, @android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void installExistingPackage(@android.annotation.NonNull java.lang.String packageName, int installReason, @android.annotation.Nullable android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void uninstallExistingPackage(@android.annotation.NonNull java.lang.String packageName, @android.annotation.Nullable android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void installPackageArchived(@android.annotation.NonNull android.content.pm.ArchivedPackageInfo archivedPackageInfo, @android.annotation.NonNull android.content.pm.PackageInstaller.SessionParams sessionParams, @android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void checkInstallConstraints(@android.annotation.NonNull java.util.List<java.lang.String> packageNames, @android.annotation.NonNull android.content.pm.PackageInstaller.InstallConstraints constraints, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.content.pm.PackageInstaller.InstallConstraintsResult> callback) { throw new RuntimeException("Stub!"); }

public void waitForInstallConstraints(@android.annotation.NonNull java.util.List<java.lang.String> packageNames, @android.annotation.NonNull android.content.pm.PackageInstaller.InstallConstraints constraints, @android.annotation.NonNull android.content.IntentSender callback, long timeoutMillis) { throw new RuntimeException("Stub!"); }

public void commitSessionAfterInstallConstraintsAreMet(int sessionId, @android.annotation.NonNull android.content.IntentSender statusReceiver, @android.annotation.NonNull android.content.pm.PackageInstaller.InstallConstraints constraints, long timeoutMillis) { throw new RuntimeException("Stub!"); }

public void registerSessionCallback(@android.annotation.NonNull android.content.pm.PackageInstaller.SessionCallback callback) { throw new RuntimeException("Stub!"); }

public void registerSessionCallback(@android.annotation.NonNull android.content.pm.PackageInstaller.SessionCallback callback, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void unregisterSessionCallback(@android.annotation.NonNull android.content.pm.PackageInstaller.SessionCallback callback) { throw new RuntimeException("Stub!"); }

public void requestArchive(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.IntentSender statusReceiver) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void requestUnarchive(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.IntentSender statusReceiver) throws java.io.IOException, android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void reportUnarchivalStatus(int unarchiveId, int status, long requiredStorageBytes, @android.annotation.Nullable android.app.PendingIntent userActionIntent) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void reportUnarchivalState(@android.annotation.NonNull android.content.pm.PackageInstaller.UnarchivalState unarchivalState) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SESSION_COMMITTED = "android.content.pm.action.SESSION_COMMITTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_SESSION_DETAILS = "android.content.pm.action.SESSION_DETAILS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SESSION_UPDATED = "android.content.pm.action.SESSION_UPDATED";

public static final java.lang.String EXTRA_INSTALL_CONSTRAINTS = "android.content.pm.extra.INSTALL_CONSTRAINTS";

public static final java.lang.String EXTRA_INSTALL_CONSTRAINTS_RESULT = "android.content.pm.extra.INSTALL_CONSTRAINTS_RESULT";

public static final java.lang.String EXTRA_OTHER_PACKAGE_NAME = "android.content.pm.extra.OTHER_PACKAGE_NAME";

public static final java.lang.String EXTRA_PACKAGE_NAME = "android.content.pm.extra.PACKAGE_NAME";

public static final java.lang.String EXTRA_PRE_APPROVAL = "android.content.pm.extra.PRE_APPROVAL";

public static final java.lang.String EXTRA_SESSION = "android.content.pm.extra.SESSION";

public static final java.lang.String EXTRA_SESSION_ID = "android.content.pm.extra.SESSION_ID";

public static final java.lang.String EXTRA_STATUS = "android.content.pm.extra.STATUS";

public static final java.lang.String EXTRA_STATUS_MESSAGE = "android.content.pm.extra.STATUS_MESSAGE";

public static final java.lang.String EXTRA_STORAGE_PATH = "android.content.pm.extra.STORAGE_PATH";

public static final java.lang.String EXTRA_UNARCHIVE_ALL_USERS = "android.content.pm.extra.UNARCHIVE_ALL_USERS";

public static final java.lang.String EXTRA_UNARCHIVE_ID = "android.content.pm.extra.UNARCHIVE_ID";

public static final java.lang.String EXTRA_UNARCHIVE_PACKAGE_NAME = "android.content.pm.extra.UNARCHIVE_PACKAGE_NAME";

public static final java.lang.String EXTRA_UNARCHIVE_STATUS = "android.content.pm.extra.UNARCHIVE_STATUS";

public static final int PACKAGE_SOURCE_DOWNLOADED_FILE = 4; // 0x4

public static final int PACKAGE_SOURCE_LOCAL_FILE = 3; // 0x3

public static final int PACKAGE_SOURCE_OTHER = 1; // 0x1

public static final int PACKAGE_SOURCE_STORE = 2; // 0x2

public static final int PACKAGE_SOURCE_UNSPECIFIED = 0; // 0x0

public static final int STATUS_FAILURE = 1; // 0x1

public static final int STATUS_FAILURE_ABORTED = 3; // 0x3

public static final int STATUS_FAILURE_BLOCKED = 2; // 0x2

public static final int STATUS_FAILURE_CONFLICT = 5; // 0x5

public static final int STATUS_FAILURE_INCOMPATIBLE = 7; // 0x7

public static final int STATUS_FAILURE_INVALID = 4; // 0x4

public static final int STATUS_FAILURE_STORAGE = 6; // 0x6

public static final int STATUS_FAILURE_TIMEOUT = 8; // 0x8

public static final int STATUS_PENDING_USER_ACTION = -1; // 0xffffffff

public static final int STATUS_SUCCESS = 0; // 0x0

public static final int UNARCHIVAL_ERROR_INSTALLER_DISABLED = 4; // 0x4

public static final int UNARCHIVAL_ERROR_INSTALLER_UNINSTALLED = 5; // 0x5

public static final int UNARCHIVAL_ERROR_INSUFFICIENT_STORAGE = 2; // 0x2

public static final int UNARCHIVAL_ERROR_NO_CONNECTIVITY = 3; // 0x3

public static final int UNARCHIVAL_ERROR_USER_ACTION_NEEDED = 1; // 0x1

public static final int UNARCHIVAL_GENERIC_ERROR = 100; // 0x64

public static final int UNARCHIVAL_OK = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class InstallConstraints implements android.os.Parcelable {

InstallConstraints() { throw new RuntimeException("Stub!"); }

public boolean isDeviceIdleRequired() { throw new RuntimeException("Stub!"); }

public boolean isAppNotForegroundRequired() { throw new RuntimeException("Stub!"); }

public boolean isAppNotInteractingRequired() { throw new RuntimeException("Stub!"); }

public boolean isAppNotTopVisibleRequired() { throw new RuntimeException("Stub!"); }

public boolean isNotInCallRequired() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageInstaller.InstallConstraints> CREATOR;
static { CREATOR = null; }

@android.annotation.NonNull public static final android.content.pm.PackageInstaller.InstallConstraints GENTLE_UPDATE;
static { GENTLE_UPDATE = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints.Builder setDeviceIdleRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints.Builder setAppNotForegroundRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints.Builder setAppNotInteractingRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints.Builder setAppNotTopVisibleRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints.Builder setNotInCallRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.InstallConstraints build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class InstallConstraintsResult implements android.os.Parcelable {

InstallConstraintsResult() { throw new RuntimeException("Stub!"); }

public boolean areAllConstraintsSatisfied() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageInstaller.InstallConstraintsResult> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PreapprovalDetails implements android.os.Parcelable {

PreapprovalDetails() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Bitmap getIcon() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getLabel() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.icu.util.ULocale getLocale() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageInstaller.PreapprovalDetails> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.PreapprovalDetails.Builder setIcon(@android.annotation.NonNull android.graphics.Bitmap value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.PreapprovalDetails.Builder setLabel(@android.annotation.NonNull java.lang.CharSequence value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.PreapprovalDetails.Builder setLocale(@android.annotation.NonNull android.icu.util.ULocale value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.PreapprovalDetails.Builder setPackageName(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.PreapprovalDetails build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Session implements java.io.Closeable {

Session() { throw new RuntimeException("Stub!"); }

public void setStagingProgress(float progress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.io.OutputStream openWrite(@android.annotation.NonNull java.lang.String name, long offsetBytes, long lengthBytes) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void fsync(@android.annotation.NonNull java.io.OutputStream out) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getNames() throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.io.InputStream openRead(@android.annotation.NonNull java.lang.String name) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void removeSplit(@android.annotation.NonNull java.lang.String splitName) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@Deprecated
public void setChecksums(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.util.List<android.content.pm.Checksum> checksums, @android.annotation.Nullable byte[] signature) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void requestChecksums(@android.annotation.NonNull java.lang.String name, int required, @android.annotation.NonNull java.util.List<java.security.cert.Certificate> trustedInstallers, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.content.pm.PackageManager.OnChecksumsReadyListener onChecksumsReadyListener) throws java.security.cert.CertificateEncodingException, java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public void commit(@android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public void transfer(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public void abandon() { throw new RuntimeException("Stub!"); }

public boolean isMultiPackage() { throw new RuntimeException("Stub!"); }

public boolean isStaged() { throw new RuntimeException("Stub!"); }

public int getParentSessionId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getChildSessionIds() { throw new RuntimeException("Stub!"); }

public void addChildSessionId(int sessionId) { throw new RuntimeException("Stub!"); }

public void removeChildSessionId(int sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getAppMetadata() { throw new RuntimeException("Stub!"); }

public void setAppMetadata(@android.annotation.Nullable android.os.PersistableBundle data) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void requestUserPreapproval(@android.annotation.NonNull android.content.pm.PackageInstaller.PreapprovalDetails details, @android.annotation.NonNull android.content.IntentSender statusReceiver) { throw new RuntimeException("Stub!"); }

public boolean isApplicationEnabledSettingPersistent() { throw new RuntimeException("Stub!"); }

public boolean isRequestUpdateOwnership() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class SessionCallback {

public SessionCallback() { throw new RuntimeException("Stub!"); }

public abstract void onCreated(int sessionId);

public abstract void onBadgingChanged(int sessionId);

public abstract void onActiveChanged(int sessionId, boolean active);

public abstract void onProgressChanged(int sessionId, float progress);

public abstract void onFinished(int sessionId, boolean success);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class SessionInfo implements android.os.Parcelable {

SessionInfo() { throw new RuntimeException("Stub!"); }

public int getSessionId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.UserHandle getUser() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getInstallerPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getInstallerAttributionTag() { throw new RuntimeException("Stub!"); }

public float getProgress() { throw new RuntimeException("Stub!"); }

public boolean isActive() { throw new RuntimeException("Stub!"); }

public boolean isSealed() { throw new RuntimeException("Stub!"); }

public int getInstallReason() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getAppPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Bitmap getAppIcon() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getAppLabel() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.Intent createDetailsIntent() { throw new RuntimeException("Stub!"); }

public int getMode() { throw new RuntimeException("Stub!"); }

public int getInstallLocation() { throw new RuntimeException("Stub!"); }

public long getSize() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri getOriginatingUri() { throw new RuntimeException("Stub!"); }

public int getOriginatingUid() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri getReferrerUri() { throw new RuntimeException("Stub!"); }

public boolean getDontKillApp() { throw new RuntimeException("Stub!"); }

public int getPackageSource() { throw new RuntimeException("Stub!"); }

public boolean isMultiPackage() { throw new RuntimeException("Stub!"); }

public boolean isStaged() { throw new RuntimeException("Stub!"); }

public boolean isStagedSessionActive() { throw new RuntimeException("Stub!"); }

public int getParentSessionId() { throw new RuntimeException("Stub!"); }

public boolean hasParentSessionId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getChildSessionIds() { throw new RuntimeException("Stub!"); }

public boolean isStagedSessionApplied() { throw new RuntimeException("Stub!"); }

public boolean isStagedSessionReady() { throw new RuntimeException("Stub!"); }

public boolean isStagedSessionFailed() { throw new RuntimeException("Stub!"); }

public int getStagedSessionErrorCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getStagedSessionErrorMessage() { throw new RuntimeException("Stub!"); }

public boolean isCommitted() { throw new RuntimeException("Stub!"); }

public long getCreatedMillis() { throw new RuntimeException("Stub!"); }

public long getUpdatedMillis() { throw new RuntimeException("Stub!"); }

public int getRequireUserAction() { throw new RuntimeException("Stub!"); }

public int getInstallerUid() { throw new RuntimeException("Stub!"); }

public boolean isApplicationEnabledSettingPersistent() { throw new RuntimeException("Stub!"); }

public boolean isPreApprovalRequested() { throw new RuntimeException("Stub!"); }

public boolean isRequestUpdateOwnership() { throw new RuntimeException("Stub!"); }

public boolean isUnarchival() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final android.os.Parcelable.Creator<android.content.pm.PackageInstaller.SessionInfo> CREATOR;
static { CREATOR = null; }

public static final int INVALID_ID = -1; // 0xffffffff

public static final int SESSION_ACTIVATION_FAILED = 2; // 0x2

public static final int SESSION_CONFLICT = 4; // 0x4

public static final int SESSION_NO_ERROR = 0; // 0x0

public static final int SESSION_UNKNOWN_ERROR = 3; // 0x3

public static final int SESSION_VERIFICATION_FAILED = 1; // 0x1

@Deprecated public static final int STAGED_SESSION_ACTIVATION_FAILED = 2; // 0x2

@Deprecated public static final int STAGED_SESSION_CONFLICT = 4; // 0x4

@Deprecated public static final int STAGED_SESSION_NO_ERROR = 0; // 0x0

@Deprecated public static final int STAGED_SESSION_UNKNOWN = 3; // 0x3

@Deprecated public static final int STAGED_SESSION_VERIFICATION_FAILED = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class SessionParams implements android.os.Parcelable {

public SessionParams(int mode) { throw new RuntimeException("Stub!"); }

public void setInstallLocation(int installLocation) { throw new RuntimeException("Stub!"); }

public void setSize(long sizeBytes) { throw new RuntimeException("Stub!"); }

public void setAppPackageName(@android.annotation.Nullable java.lang.String appPackageName) { throw new RuntimeException("Stub!"); }

public void setAppIcon(@android.annotation.Nullable android.graphics.Bitmap appIcon) { throw new RuntimeException("Stub!"); }

public void setAppLabel(@android.annotation.Nullable java.lang.CharSequence appLabel) { throw new RuntimeException("Stub!"); }

public void setOriginatingUri(@android.annotation.Nullable android.net.Uri originatingUri) { throw new RuntimeException("Stub!"); }

public void setOriginatingUid(int originatingUid) { throw new RuntimeException("Stub!"); }

public void setReferrerUri(@android.annotation.Nullable android.net.Uri referrerUri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageInstaller.SessionParams setPermissionState(@android.annotation.NonNull java.lang.String permissionName, int state) { throw new RuntimeException("Stub!"); }

public void setPackageSource(int packageSource) { throw new RuntimeException("Stub!"); }

public void setWhitelistedRestrictedPermissions(@android.annotation.Nullable java.util.Set<java.lang.String> permissions) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setAutoRevokePermissionsMode(boolean shouldAutoRevoke) { throw new RuntimeException("Stub!"); }

public void setDontKillApp(boolean dontKillApp) { throw new RuntimeException("Stub!"); }

public void setInstallReason(int installReason) { throw new RuntimeException("Stub!"); }

public void setInstallerPackageName(@android.annotation.Nullable java.lang.String installerPackageName) { throw new RuntimeException("Stub!"); }

public void setMultiPackage() { throw new RuntimeException("Stub!"); }

public void setRequireUserAction(int requireUserAction) { throw new RuntimeException("Stub!"); }

public void setInstallScenario(int installScenario) { throw new RuntimeException("Stub!"); }

public void setApplicationEnabledSettingPersistent() { throw new RuntimeException("Stub!"); }

public void setRequestUpdateOwnership(boolean enable) { throw new RuntimeException("Stub!"); }

public void setUnarchiveId(int unarchiveId) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final android.os.Parcelable.Creator<android.content.pm.PackageInstaller.SessionParams> CREATOR;
static { CREATOR = null; }

public static final int MODE_FULL_INSTALL = 1; // 0x1

public static final int MODE_INHERIT_EXISTING = 2; // 0x2

public static final int PERMISSION_STATE_DEFAULT = 0; // 0x0

public static final int PERMISSION_STATE_DENIED = 2; // 0x2

public static final int PERMISSION_STATE_GRANTED = 1; // 0x1

@android.annotation.NonNull public static final java.util.Set<java.lang.String> RESTRICTED_PERMISSIONS_ALL;
static { RESTRICTED_PERMISSIONS_ALL = null; }

public static final int USER_ACTION_NOT_REQUIRED = 2; // 0x2

public static final int USER_ACTION_REQUIRED = 1; // 0x1

public static final int USER_ACTION_UNSPECIFIED = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class UnarchivalState {

UnarchivalState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageInstaller.UnarchivalState createOkState(int unarchiveId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageInstaller.UnarchivalState createUserActionRequiredState(int unarchiveId, @android.annotation.NonNull android.app.PendingIntent userActionIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageInstaller.UnarchivalState createInsufficientStorageState(int unarchiveId, long requiredStorageBytes, @android.annotation.Nullable android.app.PendingIntent userActionIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageInstaller.UnarchivalState createNoConnectivityState(int unarchiveId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageInstaller.UnarchivalState createGenericErrorState(int unarchiveId) { throw new RuntimeException("Stub!"); }
}

}

