/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * A request to report usage of a document.
 *
 * <p>See {@link android.app.appsearch.AppSearchSession#reportUsage AppSearchSession#reportUsage} for a detailed description of usage reporting.
 *
 * @see android.app.appsearch.AppSearchSession#reportUsage
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReportUsageRequest implements android.os.Parcelable {

ReportUsageRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the namespace of the document that was used.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ID of document that was used.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDocumentId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the timestamp in milliseconds of the usage report (the time at which the document was
 * used).
 *
 * <p>The value is in the {@link java.lang.System#currentTimeMillis System#currentTimeMillis} time base.
 
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.

 * @return Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 */

public long getUsageTimestampMillis() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.ReportUsageRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.app.appsearch.ReportUsageRequest ReportUsageRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.ReportUsageRequest.Builder ReportUsageRequest.Builder} instance.
 *
 * @param namespace The namespace of the document that was used (such as from {@link android.app.appsearch.GenericDocument#getNamespace      }.
 * This value cannot be {@code null}.
 * @param documentId The ID of document that was used (such as from {@link android.app.appsearch.GenericDocument#getId      }.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String documentId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the timestamp in milliseconds of the usage report (the time at which the document
 * was used).
 *
 * <p>The value is in the {@link java.lang.System#currentTimeMillis System#currentTimeMillis} time base.
 *
 * <p>If unset, this defaults to the current timestamp at the time that the {@link android.app.appsearch.ReportUsageRequest ReportUsageRequest} is constructed.
 
 * @param usageTimestampMillis Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.ReportUsageRequest.Builder setUsageTimestampMillis(long usageTimestampMillis) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new {@link android.app.appsearch.ReportUsageRequest ReportUsageRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.ReportUsageRequest build() { throw new RuntimeException("Stub!"); }
}

}

