/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.net.Uri;
import java.time.Duration;

/**
 * The request object wrapping the required and optional parameters to schedule a deferred update
 * for Custom Audience on device. Allows AdTechs to provide an Update Uri, and the minimum Delay
 * Time to schedule the update.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScheduleCustomAudienceUpdateRequest {

ScheduleCustomAudienceUpdateRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.net.Uri Uri} from which the Custom Audience is to be fetched
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getUpdateUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link java.time.Duration Duration} min time duration for which the update is deferred
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getMinDelay() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} which are sent along with the request to
 * download the update for Custom Audience

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.customaudience.PartialCustomAudience> getPartialCustomAudienceList() { throw new RuntimeException("Stub!"); }

/** Returns the hash of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} only if two {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} objects contain
 *     the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return a human-readable representation of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Instantiates a {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder ScheduleCustomAudienceUpdateRequest.Builder} with the following
 *
 * @param updateUri from which the update for Custom Audience is to be fetched
 * This value cannot be {@code null}.
 * @param minDelay minimum delay time duration for which the update is to be deferred
 
 * This value cannot be {@code null}.

 * @param partialCustomAudienceList This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.Uri updateUri, @android.annotation.NonNull java.time.Duration minDelay, @android.annotation.NonNull java.util.List<android.adservices.customaudience.PartialCustomAudience> partialCustomAudienceList) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.net.Uri Uri} from which the update for Custom Audience is to be fetched
 *
 * <p>See {@link #getUpdateUri()} for details
 
 * @param updateUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setUpdateUri(@android.annotation.NonNull android.net.Uri updateUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.Duration Duration} , min time for which the update is to be deferred
 *
 * <p>See {@link #getMinDelay()} for more details
 
 * @param minDelay This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setMinDelay(@android.annotation.NonNull java.time.Duration minDelay) { throw new RuntimeException("Stub!"); }

/**
 * Sets list of Partial Custom Audiences that are sent to the DSP server when making a
 * request to download updates for Custom Audience
 *
 * <p>See {@link #getPartialCustomAudienceList()} for more details
 
 * @param partialCustomAudiences This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setPartialCustomAudienceList(@android.annotation.NonNull java.util.List<android.adservices.customaudience.PartialCustomAudience> partialCustomAudiences) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}
 *
 * @throws java.lang.NullPointerException if any of the non-null parameters is null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest build() { throw new RuntimeException("Stub!"); }
}

}

