/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.content.Context;
import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * AdSelection Manager provides APIs for app and ad-SDKs to run ad selection processes as well as
 * report impressions.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdSelectionManager {

AdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Factory method for creating an instance of AdSelectionManager.
 *
 * @param context The {@link android.content.Context Context} to use
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.adselection.AdSelectionManager AdSelectionManager} instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.adselection.AdSelectionManager get(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.TestAdSelectionManager getTestAdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Collects custom audience data from device. Returns a compressed and encrypted blob to send to
 * auction servers for ad selection. For more details, please visit <a
 * href="https://developer.android.com/design-for-safety/privacy-sandbox/protected-audience-bidding-and-auction-services">Bidding
 * and Auction Services Explainer</a>.
 *
 * <p>Custom audience ads must have a {@code ad_render_id} to be eligible for to be collected.
 *
 * <p>See {@link android.adservices.adselection.AdSelectionManager#persistAdSelectionResult AdSelectionManager#persistAdSelectionResult} for how to process the results of
 * the ad selection run on server-side with the blob generated by this API.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.GetAdSelectionDataOutcome GetAdSelectionDataOutcome} for a successful run, or an {@link java.lang.Exception Exception} includes the type of
 * the exception thrown and the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void getAdSelectionData(@android.annotation.NonNull android.adservices.adselection.GetAdSelectionDataRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.GetAdSelectionDataOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Persists the ad selection results from the server-side. For more details, please visit <a
 * href="https://developer.android.com/design-for-safety/privacy-sandbox/protected-audience-bidding-and-auction-services">Bidding
 * and Auction Services Explainer</a>
 *
 * <p>See {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData AdSelectionManager#getAdSelectionData} for how to generate an encrypted blob to
 * run an ad selection on the server side.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message. The {@link android.adservices.adselection.AdSelectionOutcome#getAdSelectionId() AdSelectionOutcome#getAdSelectionId()} is not
 * guaranteed to be the same as the {@link android.adservices.adselection.PersistAdSelectionResultRequest#getAdSelectionDataId()  } or the deprecated {@link android.adservices.adselection.PersistAdSelectionResultRequest#getAdSelectionId()  }.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void persistAdSelectionResult(@android.annotation.NonNull android.adservices.adselection.PersistAdSelectionResultRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.AdSelectionOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Runs the ad selection process on device to select a remarketing ad for the caller
 * application.
 *
 * <p>The input {@code adSelectionConfig} is provided by the Ads SDK and the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} object is transferred via a Binder call. For this reason, the total size
 * of these objects is bound to the Android IPC limitations. Failures to transfer the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} will throws an {@link android.os.TransactionTooLargeException TransactionTooLargeException}.
 *
 * <p>The input {@code adSelectionConfig} contains {@code Decision Logic Uri} that could follow
 * either the HTTPS or Ad Selection Prebuilt schemas.
 *
 * <p>If the URI follows HTTPS schema then the host should match the {@code seller}. Otherwise,
 * {@link java.lang.IllegalArgumentException IllegalArgumentException} will be thrown.
 *
 * <p>Prebuilt URIs are a way of substituting a generic pre-built logics for the required
 * JavaScripts for {@code scoreAds}. Prebuilt Uri for this endpoint should follow;
 *
 * <ul>
 *   <li>{@code ad-selection-prebuilt://ad-selection/<name>?<script-generation-parameters>}
 * </ul>
 *
 * <p>If an unsupported prebuilt URI is passed or prebuilt URI feature is disabled by the
 * service then {@link java.lang.IllegalArgumentException IllegalArgumentException} will be thrown.
 *
 * <p>See {@link android.adservices.adselection.AdSelectionConfig.Builder#setDecisionLogicUri AdSelectionConfig.Builder#setDecisionLogicUri} for supported {@code <name>} and
 * required {@code <script-generation-parameters>}.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}
 
 * @param adSelectionConfig This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void selectAds(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.AdSelectionOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Selects an ad from the results of previously ran ad selections.
 *
 * <p>The input {@code adSelectionFromOutcomesConfig} is provided by the Ads SDK and the {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} object is transferred via a Binder call. For this reason, the
 * total size of these objects is bound to the Android IPC limitations. Failures to transfer the
 * {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} will throws an {@link android.os.TransactionTooLargeException TransactionTooLargeException}.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>The input {@code adSelectionFromOutcomesConfig} contains:
 *
 * <ul>
 *   <li>{@code Seller} is required to be a registered {@link
 *       android.adservices.common.AdTechIdentifier}. Otherwise, {@link java.lang.IllegalStateException IllegalStateException}
 *       will be thrown.
 *   <li>{@code List of ad selection ids} should exist and come from {@link android.adservices.adselection.AdSelectionManager#selectAds        } calls originated from the same application. Otherwise,
 *       {@link java.lang.IllegalArgumentException IllegalArgumentException} for input validation will raise listing violating ad
 *       selection ids.
 *   <li>{@code Selection logic URI} that could follow either the HTTPS or Ad Selection Prebuilt
 *       schemas.
 *       <p>If the URI follows HTTPS schema then the host should match the {@code seller}.
 *       Otherwise, {@link java.lang.IllegalArgumentException IllegalArgumentException} will be thrown.
 *       <p>Prebuilt URIs are a way of substituting a generic pre-built logics for the required
 *       JavaScripts for {@code selectOutcome}. Prebuilt Uri for this endpoint should follow;
 *       <ul>
 *         <li>{@code
 *             ad-selection-prebuilt://ad-selection-from-outcomes/<name>?<script-generation-parameters>}
 *       </ul>
 *       <p>If an unsupported prebuilt URI is passed or prebuilt URI feature is disabled by the
 *       service then {@link java.lang.IllegalArgumentException IllegalArgumentException} will be thrown.
 *       <p>See {@link android.adservices.adselection.AdSelectionFromOutcomesConfig.Builder#setSelectionLogicUri AdSelectionFromOutcomesConfig.Builder#setSelectionLogicUri} for supported
 *       {@code <name>} and required {@code <script-generation-parameters>}.
 * </ul>
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}
 
 * @param adSelectionFromOutcomesConfig This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void selectAds(@android.annotation.NonNull android.adservices.adselection.AdSelectionFromOutcomesConfig adSelectionFromOutcomesConfig, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.AdSelectionOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Notifies the service that there is a new impression to report for the ad selected by the
 * ad-selection run identified by {@code adSelectionId}. There is no guarantee about when the
 * impression will be reported. The impression reporting could be delayed and reports could be
 * batched.
 *
 * <p>To calculate the winning seller reporting URL, the service fetches the seller's JavaScript
 * logic from the {@link android.adservices.adselection.AdSelectionConfig#getDecisionLogicUri() AdSelectionConfig#getDecisionLogicUri()} found at {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig()  }. Then, the service executes one of the
 * functions found in the seller JS called {@code reportResult}, providing on-device signals as
 * well as {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig() ReportImpressionRequest#getAdSelectionConfig()} as input parameters.
 *
 * <p>The function definition of {@code reportResult} is:
 *
 * <p>{@code function reportResult(ad_selection_config, render_url, bid, contextual_signals) {
 * return { 'status': status, 'results': {'signals_for_buyer': signals_for_buyer,
 * 'reporting_url': reporting_url } }; } }
 *
 * <p>To calculate the winning buyer reporting URL, the service fetches the winning buyer's
 * JavaScript logic which is fetched via the buyer's {@link
 * android.adservices.customaudience.CustomAudience#getBiddingLogicUri()}. Then, the service
 * executes one of the functions found in the buyer JS called {@code reportWin}, providing
 * on-device signals, {@code signals_for_buyer} calculated by {@code reportResult}, and specific
 * fields from {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig() ReportImpressionRequest#getAdSelectionConfig()} as input parameters.
 *
 * <p>The function definition of {@code reportWin} is:
 *
 * <p>{@code function reportWin(ad_selection_signals, per_buyer_signals, signals_for_buyer,
 * contextual_signals, custom_audience_reporting_signals) { return {'status': 0, 'results':
 * {'reporting_url': reporting_url } }; } }
 *
 * <p>In addition, buyers and sellers have the option to register to receive reports on specific
 * ad events. To do so, they can invoke the platform provided {@code registerAdBeacon} function
 * inside {@code reportWin} and {@code reportResult} for buyers and sellers, respectively.
 *
 * <p>The function definition of {@code registerBeacon} is:
 *
 * <p>{@code function registerAdBeacon(beacons)}, where {@code beacons} is a dict of string to
 * string pairs
 *
 * <p>For each ad event a buyer/seller is interested in reports for, they would add an {@code
 * event_key}: {@code event_reporting_uri} pair to the {@code beacons} dict, where {@code
 * event_key} is an identifier for that specific event. This {@code event_key} should match
 * {@link android.adservices.adselection.ReportEventRequest#getKey() ReportEventRequest#getKey()} when the SDK invokes {@link #reportEvent}. In addition,
 * each {@code event_reporting_uri} should parse properly into a {@link android.net.Uri}. This
 * will be the {@link android.net.Uri} reported to when the SDK invokes {@link #reportEvent}.
 *
 * <p>When the buyer/seller has added all the pairings they want to receive events for, they can
 * invoke {@code registerAdBeacon(beacons)}, where {@code beacons} is the name of the dict they
 * added the pairs to.
 *
 * <p>{@code registerAdBeacon} will throw a {@code TypeError} in these situations:
 *
 * <ol>
 *   <li>{@code registerAdBeacon}is called more than once. If this error is caught in
 *       reportWin/reportResult, the original set of pairings will be registered
 *   <li>{@code registerAdBeacon} doesn't have exactly 1 dict argument.
 *   <li>The contents of the 1 dict argument are not all {@code String: String} pairings.
 * </ol>
 *
 * <p>The output is passed by the {@code receiver}, which either returns an empty {@link java.lang.Object Object}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to report the impression.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.
 *
 * <p>Impressions will be reported at most once as a best-effort attempt.
 
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param receiver This value cannot be {@code null}.
 */

public void reportImpression(@android.annotation.NonNull android.adservices.adselection.ReportImpressionRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Notifies the service that there is a new ad event to report for the ad selected by the
 * ad-selection run identified by {@code adSelectionId}. An ad event is any occurrence that
 * happens to an ad associated with the given {@code adSelectionId}. There is no guarantee about
 * when the ad event will be reported. The event reporting could be delayed and reports could be
 * batched.
 *
 * <p>Using {@link android.adservices.adselection.ReportEventRequest#getKey() ReportEventRequest#getKey()}, the service will fetch the {@code reportingUri}
 * that was registered in {@code registerAdBeacon}. See documentation of {@link
 * #reportImpression} for more details regarding {@code registerAdBeacon}. Then, the service
 * will attach {@link android.adservices.adselection.ReportEventRequest#getData() ReportEventRequest#getData()} to the request body of a POST request and
 * send the request. The body of the POST request will have the {@code content-type} of {@code
 * text/plain}, and the data will be transmitted in {@code charset=UTF-8}.
 *
 * <p>The output is passed by the receiver, which either returns an empty {@link java.lang.Object Object} for a
 * successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and the
 * corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to report the ad event.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.
 *
 * <p>Events will be reported at most once as a best-effort attempt.
 
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param receiver This value cannot be {@code null}.
 */

public void reportEvent(@android.annotation.NonNull android.adservices.adselection.ReportEventRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Gives the provided list of adtechs the ability to do app install filtering on the calling
 * app.
 *
 * <p>The input {@code request} is provided by the Ads SDK and the {@code request} object is
 * transferred via a Binder call. For this reason, the total size of these objects is bound to
 * the Android IPC limitations. Failures to transfer the {@code advertisers} will throws an
 * {@link android.os.TransactionTooLargeException TransactionTooLargeException}.
 *
 * <p>The output is passed by the receiver, which either returns an empty {@link java.lang.Object Object} for a
 * successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and the
 * corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.
 
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param receiver This value cannot be {@code null}.
 */

public void setAppInstallAdvertisers(@android.annotation.NonNull android.adservices.adselection.SetAppInstallAdvertisersRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Updates the counter histograms for an ad which was previously selected by a call to {@link
 * #selectAds(android.adservices.adselection.AdSelectionConfig,java.util.concurrent.Executor,android.os.OutcomeReceiver)}.
 *
 * <p>The counter histograms are used in ad selection to inform frequency cap filtering on
 * candidate ads, where ads whose frequency caps are met or exceeded are removed from the
 * bidding process during ad selection.
 *
 * <p>Counter histograms can only be updated for ads specified by the given {@code
 * adSelectionId} returned by a recent call to FLEDGE ad selection from the same caller app.
 *
 * <p>A {@link java.lang.SecurityException SecurityException} is returned via the {@code outcomeReceiver} if:
 *
 * <ol>
 *   <li>the app has not declared the correct permissions in its manifest, or
 *   <li>the app or entity identified by the {@code callerAdTechIdentifier} are not authorized
 *       to use the API.
 * </ol>
 *
 * An {@link java.lang.IllegalStateException IllegalStateException} is returned via the {@code outcomeReceiver} if the call does
 * not come from an app with a foreground activity.
 *
 * <p>A {@link android.os.LimitExceededException LimitExceededException} is returned via the {@code outcomeReceiver} if the call
 * exceeds the calling app's API throttle.
 *
 * <p>In all other failure cases, the {@code outcomeReceiver} will return an empty {@link java.lang.Object Object}. Note that to protect user privacy, internal errors will not be sent back via an
 * exception.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_PROTECTED_SIGNALS} or {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_SELECTION}
 
 * @param updateAdCounterHistogramRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param outcomeReceiver This value cannot be {@code null}.
 */

public void updateAdCounterHistogram(@android.annotation.NonNull android.adservices.adselection.UpdateAdCounterHistogramRequest updateAdCounterHistogramRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> outcomeReceiver) { throw new RuntimeException("Stub!"); }
}

