/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.security.spec;


/**
 * This class is used to specify any algorithm parameters that are determined
 * by a standard name. This class also holds constants for standard parameter
 * set names. The names of these constants exactly match the corresponding
 * parameter set name. For example, NamedParameterSpec.X25519 represents the
 * parameter set identified by the string "X25519". These strings are defined
 * in the <a href=
 * "https://docs.oracle.com/en/java/javase/17/docs/specs/security/standard-names.html#parameterspec-names">
 *          Java Security Standard Algorithm Names Specification</a>.
 *
 * @since 11
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class NamedParameterSpec implements java.security.spec.AlgorithmParameterSpec {

/**
 * Creates a parameter specification using a standard (or predefined)
 * name {@code stdName}. For the
 * list of supported names, please consult the documentation
 * of the provider whose implementation will be used.
 *
 * @param stdName the standard name of the algorithm parameters. See the
 *        ParameterSpec Names section in the
 *        <a href=
 *        "https://docs.oracle.com/en/java/javase/17/docs/specs/security/standard-names.html#parameterspec-names">
 *        Java Security Standard Algorithm Names Specification</a> for
 *        information about standard names.
 *
 * @throws java.lang.NullPointerException if {@code stdName} is null.
 */

public NamedParameterSpec(@androidx.annotation.RecentlyNonNull java.lang.String stdName) { throw new RuntimeException("Stub!"); }

/**
 * Returns the standard name that determines the algorithm parameters.
 * @return the standard name.
 */

@androidx.annotation.RecentlyNonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * The Ed25519 parameters
 *
 * @since 15
 */

public static final java.security.spec.NamedParameterSpec ED25519;
static { ED25519 = null; }

/**
 * The Ed448 parameters
 *
 * @since 15
 */

public static final java.security.spec.NamedParameterSpec ED448;
static { ED448 = null; }

/**
 * The X25519 parameters
 */

public static final java.security.spec.NamedParameterSpec X25519;
static { X25519 = null; }

/**
 * The X448 parameters
 */

public static final java.security.spec.NamedParameterSpec X448;
static { X448 = null; }
}

