/*
 * Copyright (c) 2017, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang.runtime;

import java.lang.invoke.MethodType;
import java.lang.invoke.MethodHandle;

/**
 * Bootstrap methods for state-driven implementations of core methods,
 * including {@link java.lang.Object#equals(java.lang.Object) Object#equals(Object)}, {@link java.lang.Object#hashCode() Object#hashCode()}, and
 * {@link java.lang.Object#toString() Object#toString()}.  These methods may be used, for example, by
 * Java compiler implementations to implement the bodies of {@link java.lang.Object Object}
 * methods for record classes.
 *
 * @since 16
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ObjectMethods {

ObjectMethods() { throw new RuntimeException("Stub!"); }

/**
 * Bootstrap method to generate the {@link java.lang.Object#equals(java.lang.Object) Object#equals(Object)},
 * {@link java.lang.Object#hashCode() Object#hashCode()}, and {@link java.lang.Object#toString() Object#toString()} methods, based
 * on a description of the component names and accessor methods, for either
 * {@code invokedynamic} call sites or dynamic constant pool entries.
 *
 * For more detail on the semantics of the generated methods see the specification
 * of {@link java.lang.Record#equals(Object)}, {@link java.lang.Record#hashCode()} and
 * {@link java.lang.Record#toString()}.
 *
 *
 * @param lookup       Every bootstrap method is expected to have a {@code lookup}
 *                     which usually represents a lookup context with the
 *                     accessibility privileges of the caller. This is because
 *                     {@code invokedynamic} call sites always provide a {@code lookup}
 *                     to the corresponding bootstrap method, but this method just
 *                     ignores the {@code lookup} parameter
 * @param methodName   the name of the method to generate, which must be one of
 *                     {@code "equals"}, {@code "hashCode"}, or {@code "toString"}
 * @param type         a {@link java.lang.invoke.MethodType MethodType} corresponding the descriptor type
 *                     for the method, which must correspond to the descriptor
 *                     for the corresponding {@link java.lang.Object Object} method, if linking
 *                     an {@code invokedynamic} call site, or the
 *                     constant {@code MethodHandle.class}, if linking a
 *                     dynamic constant
 * @param recordClass  the record class hosting the record components
 * @param names        the list of component names, joined into a string
 *                     separated by ";", or the empty string if there are no
 *                     components. Maybe be null, if the {@code methodName}
 *                     is {@code "equals"} or {@code "hashCode"}.
 * @param getters      method handles for the accessor methods for the components
 * @return             a call site if invoked by indy, or a method handle
 *                     if invoked by a condy
 * @throws java.lang.IllegalArgumentException if the bootstrap arguments are invalid
 *                                  or inconsistent
 * @throws java.lang.Throwable if any exception is thrown during call site construction
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.Object bootstrap(@androidx.annotation.RecentlyNonNull java.lang.invoke.MethodHandles.Lookup lookup, @androidx.annotation.RecentlyNonNull java.lang.String methodName, @androidx.annotation.RecentlyNonNull java.lang.invoke.TypeDescriptor type, @androidx.annotation.RecentlyNonNull java.lang.Class<?> recordClass, @androidx.annotation.RecentlyNullable java.lang.String names, @androidx.annotation.RecentlyNonNull java.lang.invoke.MethodHandle... getters) throws java.lang.Throwable { throw new RuntimeException("Stub!"); }
}

