/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TelephonyManager {

TelephonyManager() { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPhoneCount() { throw new RuntimeException("Stub!"); }

public int getActiveModemCount() { throw new RuntimeException("Stub!"); }

public int getSupportedModemCount() { throw new RuntimeException("Stub!"); }

public android.telephony.TelephonyManager createForSubscriptionId(int subId) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.TelephonyManager createForPhoneAccountHandle(android.telecom.PhoneAccountHandle phoneAccountHandle) { throw new RuntimeException("Stub!"); }

public static long getMaximumCallComposerPictureSize() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDeviceSoftwareVersion() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.String getDeviceId() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.String getDeviceId(int slotIndex) { throw new RuntimeException("Stub!"); }

public java.lang.String getImei() { throw new RuntimeException("Stub!"); }

public java.lang.String getImei(int slotIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getTypeAllocationCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getTypeAllocationCode(int slotIndex) { throw new RuntimeException("Stub!"); }

public java.lang.String getMeid() { throw new RuntimeException("Stub!"); }

public java.lang.String getMeid(int slotIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getManufacturerCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getManufacturerCode(int slotIndex) { throw new RuntimeException("Stub!"); }

public java.lang.String getNai() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.telephony.CellLocation getCellLocation() { throw new RuntimeException("Stub!"); }

public int getPhoneType() { throw new RuntimeException("Stub!"); }

public java.lang.String getNetworkOperatorName() { throw new RuntimeException("Stub!"); }

public java.lang.String getNetworkOperator() { throw new RuntimeException("Stub!"); }

public java.lang.String getNetworkSpecifier() { throw new RuntimeException("Stub!"); }

public android.os.PersistableBundle getCarrierConfig() { throw new RuntimeException("Stub!"); }

public boolean isNetworkRoaming() { throw new RuntimeException("Stub!"); }

public java.lang.String getNetworkCountryIso() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getNetworkCountryIso(int slotIndex) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getNetworkType() { throw new RuntimeException("Stub!"); }

public int getDataNetworkType() { throw new RuntimeException("Stub!"); }

public int getVoiceNetworkType() { throw new RuntimeException("Stub!"); }

public boolean hasIccCard() { throw new RuntimeException("Stub!"); }

public int getSimState() { throw new RuntimeException("Stub!"); }

public int getSimState(int slotIndex) { throw new RuntimeException("Stub!"); }

public java.lang.String getSimOperator() { throw new RuntimeException("Stub!"); }

public java.lang.String getSimOperatorName() { throw new RuntimeException("Stub!"); }

public java.lang.String getSimCountryIso() { throw new RuntimeException("Stub!"); }

public java.lang.String getSimSerialNumber() { throw new RuntimeException("Stub!"); }

public int getCardIdForDefaultEuicc() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.telephony.UiccCardInfo> getUiccCardsInfo() { throw new RuntimeException("Stub!"); }

public java.lang.String getSubscriberId() { throw new RuntimeException("Stub!"); }

public void uploadCallComposerPicture(@android.annotation.NonNull java.nio.file.Path pictureToUpload, @android.annotation.NonNull java.lang.String contentType, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.os.ParcelUuid,android.telephony.TelephonyManager.CallComposerException> callback) { throw new RuntimeException("Stub!"); }

public void uploadCallComposerPicture(@android.annotation.NonNull java.io.InputStream pictureToUpload, @android.annotation.NonNull java.lang.String contentType, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.os.ParcelUuid,android.telephony.TelephonyManager.CallComposerException> callback) { throw new RuntimeException("Stub!"); }

public java.lang.String getGroupIdLevel1() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.String getLine1Number() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean setLine1NumberForDisplay(java.lang.String alphaTag, java.lang.String number) { throw new RuntimeException("Stub!"); }

public java.lang.String getVoiceMailNumber() { throw new RuntimeException("Stub!"); }

public boolean setVoiceMailNumber(java.lang.String alphaTag, java.lang.String number) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getVisualVoicemailPackageName() { throw new RuntimeException("Stub!"); }

public void setVisualVoicemailSmsFilterSettings(android.telephony.VisualVoicemailSmsFilterSettings settings) { throw new RuntimeException("Stub!"); }

public void sendVisualVoicemailSms(java.lang.String number, int port, java.lang.String text, android.app.PendingIntent sentIntent) { throw new RuntimeException("Stub!"); }

public java.lang.String getVoiceMailAlphaTag() { throw new RuntimeException("Stub!"); }

public void sendDialerSpecialCode(java.lang.String inputCode) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getCallState() { throw new RuntimeException("Stub!"); }

public int getCallStateForSubscription() { throw new RuntimeException("Stub!"); }

public int getDataActivity() { throw new RuntimeException("Stub!"); }

public int getDataState() { throw new RuntimeException("Stub!"); }

@Deprecated
public void listen(android.telephony.PhoneStateListener listener, int events) { throw new RuntimeException("Stub!"); }

public boolean isVoiceCapable() { throw new RuntimeException("Stub!"); }

public boolean isSmsCapable() { throw new RuntimeException("Stub!"); }

public java.util.List<android.telephony.CellInfo> getAllCellInfo() { throw new RuntimeException("Stub!"); }

public void requestCellInfoUpdate(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.TelephonyManager.CellInfoCallback callback) { throw new RuntimeException("Stub!"); }

public java.lang.String getMmsUserAgent() { throw new RuntimeException("Stub!"); }

public java.lang.String getMmsUAProfUrl() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.telephony.IccOpenLogicalChannelResponse iccOpenLogicalChannel(java.lang.String AID) { throw new RuntimeException("Stub!"); }

public android.telephony.IccOpenLogicalChannelResponse iccOpenLogicalChannel(java.lang.String AID, int p2) { throw new RuntimeException("Stub!"); }

public boolean iccCloseLogicalChannel(int channel) { throw new RuntimeException("Stub!"); }

public java.lang.String iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, java.lang.String data) { throw new RuntimeException("Stub!"); }

public java.lang.String iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, java.lang.String data) { throw new RuntimeException("Stub!"); }

public byte[] iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, java.lang.String filePath) { throw new RuntimeException("Stub!"); }

public java.lang.String sendEnvelopeWithStatus(java.lang.String content) { throw new RuntimeException("Stub!"); }

public void rebootModem() { throw new RuntimeException("Stub!"); }

public int getSubscriptionId() { throw new RuntimeException("Stub!"); }

public java.lang.String getIccAuthentication(int appType, int authType, java.lang.String data) { throw new RuntimeException("Stub!"); }

public java.lang.String[] getForbiddenPlmns() { throw new RuntimeException("Stub!"); }

public int setForbiddenPlmns(@android.annotation.NonNull java.util.List<java.lang.String> fplmns) { throw new RuntimeException("Stub!"); }

public void setNetworkSelectionModeAutomatic() { throw new RuntimeException("Stub!"); }

public android.telephony.NetworkScan requestNetworkScan(android.telephony.NetworkScanRequest request, java.util.concurrent.Executor executor, android.telephony.TelephonyScanManager.NetworkScanCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.NetworkScan requestNetworkScan(int includeLocationData, @android.annotation.NonNull android.telephony.NetworkScanRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.TelephonyScanManager.NetworkScanCallback callback) { throw new RuntimeException("Stub!"); }

public boolean setNetworkSelectionModeManual(java.lang.String operatorNumeric, boolean persistSelection) { throw new RuntimeException("Stub!"); }

public boolean setNetworkSelectionModeManual(@android.annotation.NonNull java.lang.String operatorNumeric, boolean persistSelection, int ran) { throw new RuntimeException("Stub!"); }

public int getNetworkSelectionMode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getManualNetworkSelectionPlmn() { throw new RuntimeException("Stub!"); }

public void setAllowedNetworkTypesForReason(int reason, long allowedNetworkTypes) { throw new RuntimeException("Stub!"); }

public long getAllowedNetworkTypesForReason(int reason) { throw new RuntimeException("Stub!"); }

public boolean setPreferredNetworkTypeToGlobal() { throw new RuntimeException("Stub!"); }

public boolean hasCarrierPrivileges() { throw new RuntimeException("Stub!"); }

public boolean setOperatorBrandOverride(java.lang.String brand) { throw new RuntimeException("Stub!"); }

public void setCallComposerStatus(int status) { throw new RuntimeException("Stub!"); }

public int getCallComposerStatus() { throw new RuntimeException("Stub!"); }

public void sendUssdRequest(java.lang.String ussdRequest, android.telephony.TelephonyManager.UssdResponseCallback callback, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public boolean isConcurrentVoiceAndDataSupported() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setDataEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean isDataEnabled() { throw new RuntimeException("Stub!"); }

public boolean isDataRoamingEnabled() { throw new RuntimeException("Stub!"); }

public boolean canChangeDtmfToneLength() { throw new RuntimeException("Stub!"); }

public boolean isWorldPhone() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isTtyModeSupported() { throw new RuntimeException("Stub!"); }

public boolean isRttSupported() { throw new RuntimeException("Stub!"); }

public boolean isHearingAidCompatibilitySupported() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telecom.PhoneAccountHandle getPhoneAccountHandle() { throw new RuntimeException("Stub!"); }

public int getSubscriptionId(@android.annotation.NonNull android.telecom.PhoneAccountHandle phoneAccountHandle) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.ServiceState getServiceState() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.ServiceState getServiceState(int includeLocationData) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri getVoicemailRingtoneUri(android.telecom.PhoneAccountHandle accountHandle) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setVoicemailRingtoneUri(android.telecom.PhoneAccountHandle phoneAccountHandle, android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public boolean isVoicemailVibrationEnabled(android.telecom.PhoneAccountHandle accountHandle) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setVoicemailVibrationEnabled(android.telecom.PhoneAccountHandle phoneAccountHandle, boolean enabled) { throw new RuntimeException("Stub!"); }

public int getSimCarrierId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getSimCarrierIdName() { throw new RuntimeException("Stub!"); }

public int getSimSpecificCarrierId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getSimSpecificCarrierIdName() { throw new RuntimeException("Stub!"); }

public int getCarrierIdFromSimMccMnc() { throw new RuntimeException("Stub!"); }

public void getCarrierRestrictionStatus(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> resultListener) { throw new RuntimeException("Stub!"); }

public void setDataEnabledForReason(int reason, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isDataEnabledForReason(int reason) { throw new RuntimeException("Stub!"); }

public boolean isManualNetworkSelectionAllowed() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.telephony.SignalStrength getSignalStrength() { throw new RuntimeException("Stub!"); }

public boolean isDataConnectionAllowed() { throw new RuntimeException("Stub!"); }

public boolean isDataCapable() { throw new RuntimeException("Stub!"); }

public long getSupportedRadioAccessFamily() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,java.util.List<android.telephony.emergency.EmergencyNumber>> getEmergencyNumberList() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,java.util.List<android.telephony.emergency.EmergencyNumber>> getEmergencyNumberList(int categories) { throw new RuntimeException("Stub!"); }

public boolean isEmergencyNumber(@android.annotation.NonNull java.lang.String number) { throw new RuntimeException("Stub!"); }

public void setPreferredOpportunisticDataSubscription(int subId, boolean needValidation, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable java.util.function.Consumer<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

public int getPreferredOpportunisticDataSubscription() { throw new RuntimeException("Stub!"); }

public void updateAvailableNetworks(@android.annotation.NonNull java.util.List<android.telephony.AvailableNetworkInfo> availableNetworks, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable java.util.function.Consumer<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

public boolean isModemEnabledForSlot(int slotIndex) { throw new RuntimeException("Stub!"); }

public int isMultiSimSupported() { throw new RuntimeException("Stub!"); }

public void switchMultiSimConfig(int numOfSims) { throw new RuntimeException("Stub!"); }

public boolean doesSwitchMultiSimConfigTriggerReboot() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getEquivalentHomePlmns() { throw new RuntimeException("Stub!"); }

public boolean isRadioInterfaceCapabilitySupported(@android.annotation.NonNull java.lang.String capability) { throw new RuntimeException("Stub!"); }

public void registerTelephonyCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.TelephonyCallback callback) { throw new RuntimeException("Stub!"); }

public void registerTelephonyCallback(int includeLocationData, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.TelephonyCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterTelephonyCallback(@android.annotation.NonNull android.telephony.TelephonyCallback callback) { throw new RuntimeException("Stub!"); }

public void setSignalStrengthUpdateRequest(@android.annotation.NonNull android.telephony.SignalStrengthUpdateRequest request) { throw new RuntimeException("Stub!"); }

public void clearSignalStrengthUpdateRequest(@android.annotation.NonNull android.telephony.SignalStrengthUpdateRequest request) { throw new RuntimeException("Stub!"); }

public void getNetworkSlicingConfiguration(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.telephony.data.NetworkSlicingConfig,android.telephony.TelephonyManager.NetworkSlicingException> callback) { throw new RuntimeException("Stub!"); }

public boolean isPremiumCapabilityAvailableForPurchase(int capability) { throw new RuntimeException("Stub!"); }

public void purchasePremiumCapability(int capability, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getPrimaryImei() { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String ACTION_CARRIER_MESSAGING_CLIENT_SERVICE = "android.telephony.action.CARRIER_MESSAGING_CLIENT_SERVICE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE = "android.telephony.action.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CARRIER_SIGNAL_PCO_VALUE = "android.telephony.action.CARRIER_SIGNAL_PCO_VALUE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CARRIER_SIGNAL_REDIRECTED = "android.telephony.action.CARRIER_SIGNAL_REDIRECTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CARRIER_SIGNAL_REQUEST_NETWORK_FAILED = "android.telephony.action.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CARRIER_SIGNAL_RESET = "android.telephony.action.CARRIER_SIGNAL_RESET";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_CONFIGURE_VOICEMAIL = "android.telephony.action.CONFIGURE_VOICEMAIL";

public static final java.lang.String ACTION_MULTI_SIM_CONFIG_CHANGED = "android.telephony.action.MULTI_SIM_CONFIG_CHANGED";

public static final java.lang.String ACTION_NETWORK_COUNTRY_CHANGED = "android.telephony.action.NETWORK_COUNTRY_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SECRET_CODE = "android.telephony.action.SECRET_CODE";

public static final java.lang.String ACTION_SHOW_VOICEMAIL_NOTIFICATION = "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SUBSCRIPTION_CARRIER_IDENTITY_CHANGED = "android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED = "android.telephony.action.SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED";

public static final int ALLOWED_NETWORK_TYPES_REASON_CARRIER = 2; // 0x2

public static final int ALLOWED_NETWORK_TYPES_REASON_USER = 0; // 0x0

public static final int APPTYPE_CSIM = 4; // 0x4

public static final int APPTYPE_ISIM = 5; // 0x5

public static final int APPTYPE_RUIM = 3; // 0x3

public static final int APPTYPE_SIM = 1; // 0x1

public static final int APPTYPE_UNKNOWN = 0; // 0x0

public static final int APPTYPE_USIM = 2; // 0x2

public static final int AUTHTYPE_EAP_AKA = 129; // 0x81

public static final int AUTHTYPE_EAP_SIM = 128; // 0x80

public static final int AUTHTYPE_GBA_BOOTSTRAP = 132; // 0x84

public static final int AUTHTYPE_GBA_NAF_KEY_EXTERNAL = 133; // 0x85

public static final int CALL_COMPOSER_STATUS_OFF = 0; // 0x0

public static final int CALL_COMPOSER_STATUS_ON = 1; // 0x1

public static final int CALL_STATE_IDLE = 0; // 0x0

public static final int CALL_STATE_OFFHOOK = 2; // 0x2

public static final int CALL_STATE_RINGING = 1; // 0x1

public static final java.lang.String CAPABILITY_SLICING_CONFIG_SUPPORTED = "CAPABILITY_SLICING_CONFIG_SUPPORTED";

public static final int CARRIER_RESTRICTION_STATUS_NOT_RESTRICTED = 1; // 0x1

public static final int CARRIER_RESTRICTION_STATUS_RESTRICTED = 2; // 0x2

public static final int CARRIER_RESTRICTION_STATUS_RESTRICTED_TO_CALLER = 3; // 0x3

public static final int CARRIER_RESTRICTION_STATUS_UNKNOWN = 0; // 0x0

public static final int CDMA_ROAMING_MODE_AFFILIATED = 1; // 0x1

public static final int CDMA_ROAMING_MODE_ANY = 2; // 0x2

public static final int CDMA_ROAMING_MODE_HOME = 0; // 0x0

public static final int CDMA_ROAMING_MODE_RADIO_DEFAULT = -1; // 0xffffffff

public static final int DATA_ACTIVITY_DORMANT = 4; // 0x4

public static final int DATA_ACTIVITY_IN = 1; // 0x1

public static final int DATA_ACTIVITY_INOUT = 3; // 0x3

public static final int DATA_ACTIVITY_NONE = 0; // 0x0

public static final int DATA_ACTIVITY_OUT = 2; // 0x2

public static final int DATA_CONNECTED = 2; // 0x2

public static final int DATA_CONNECTING = 1; // 0x1

public static final int DATA_DISCONNECTED = 0; // 0x0

public static final int DATA_DISCONNECTING = 4; // 0x4

public static final int DATA_ENABLED_REASON_CARRIER = 2; // 0x2

public static final int DATA_ENABLED_REASON_OVERRIDE = 4; // 0x4

public static final int DATA_ENABLED_REASON_POLICY = 1; // 0x1

public static final int DATA_ENABLED_REASON_THERMAL = 3; // 0x3

public static final int DATA_ENABLED_REASON_UNKNOWN = -1; // 0xffffffff

public static final int DATA_ENABLED_REASON_USER = 0; // 0x0

public static final int DATA_HANDOVER_IN_PROGRESS = 5; // 0x5

public static final int DATA_SUSPENDED = 3; // 0x3

public static final int DATA_UNKNOWN = -1; // 0xffffffff

public static final int DEFAULT_PORT_INDEX = 0; // 0x0

public static final int ERI_FLASH = 2; // 0x2

public static final int ERI_OFF = 1; // 0x1

public static final int ERI_ON = 0; // 0x0

public static final java.lang.String EXTRA_ACTIVE_SIM_SUPPORTED_COUNT = "android.telephony.extra.ACTIVE_SIM_SUPPORTED_COUNT";

public static final java.lang.String EXTRA_APN_PROTOCOL = "android.telephony.extra.APN_PROTOCOL";

public static final java.lang.String EXTRA_APN_TYPE = "android.telephony.extra.APN_TYPE";

public static final java.lang.String EXTRA_CALL_VOICEMAIL_INTENT = "android.telephony.extra.CALL_VOICEMAIL_INTENT";

public static final java.lang.String EXTRA_CARRIER_ID = "android.telephony.extra.CARRIER_ID";

public static final java.lang.String EXTRA_CARRIER_NAME = "android.telephony.extra.CARRIER_NAME";

public static final java.lang.String EXTRA_DATA_FAIL_CAUSE = "android.telephony.extra.DATA_FAIL_CAUSE";

public static final java.lang.String EXTRA_DEFAULT_NETWORK_AVAILABLE = "android.telephony.extra.DEFAULT_NETWORK_AVAILABLE";

public static final java.lang.String EXTRA_HIDE_PUBLIC_SETTINGS = "android.telephony.extra.HIDE_PUBLIC_SETTINGS";

@Deprecated public static final java.lang.String EXTRA_INCOMING_NUMBER = "incoming_number";

public static final java.lang.String EXTRA_IS_REFRESH = "android.telephony.extra.IS_REFRESH";

public static final java.lang.String EXTRA_LAST_KNOWN_NETWORK_COUNTRY = "android.telephony.extra.LAST_KNOWN_NETWORK_COUNTRY";

public static final java.lang.String EXTRA_LAUNCH_VOICEMAIL_SETTINGS_INTENT = "android.telephony.extra.LAUNCH_VOICEMAIL_SETTINGS_INTENT";

public static final java.lang.String EXTRA_NETWORK_COUNTRY = "android.telephony.extra.NETWORK_COUNTRY";

public static final java.lang.String EXTRA_NOTIFICATION_COUNT = "android.telephony.extra.NOTIFICATION_COUNT";

public static final java.lang.String EXTRA_PCO_ID = "android.telephony.extra.PCO_ID";

public static final java.lang.String EXTRA_PCO_VALUE = "android.telephony.extra.PCO_VALUE";

public static final java.lang.String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telephony.extra.PHONE_ACCOUNT_HANDLE";

public static final java.lang.String EXTRA_REDIRECTION_URL = "android.telephony.extra.REDIRECTION_URL";

public static final java.lang.String EXTRA_SPECIFIC_CARRIER_ID = "android.telephony.extra.SPECIFIC_CARRIER_ID";

public static final java.lang.String EXTRA_SPECIFIC_CARRIER_NAME = "android.telephony.extra.SPECIFIC_CARRIER_NAME";

public static final java.lang.String EXTRA_STATE = "state";

public static final java.lang.String EXTRA_STATE_IDLE;
static { EXTRA_STATE_IDLE = null; }

public static final java.lang.String EXTRA_STATE_OFFHOOK;
static { EXTRA_STATE_OFFHOOK = null; }

public static final java.lang.String EXTRA_STATE_RINGING;
static { EXTRA_STATE_RINGING = null; }

public static final java.lang.String EXTRA_SUBSCRIPTION_ID = "android.telephony.extra.SUBSCRIPTION_ID";

public static final java.lang.String EXTRA_VOICEMAIL_NUMBER = "android.telephony.extra.VOICEMAIL_NUMBER";

public static final int INCLUDE_LOCATION_DATA_COARSE = 1; // 0x1

public static final int INCLUDE_LOCATION_DATA_FINE = 2; // 0x2

public static final int INCLUDE_LOCATION_DATA_NONE = 0; // 0x0

public static final java.lang.String METADATA_HIDE_VOICEMAIL_SETTINGS_MENU = "android.telephony.HIDE_VOICEMAIL_SETTINGS_MENU";

public static final int MULTISIM_ALLOWED = 0; // 0x0

public static final int MULTISIM_NOT_SUPPORTED_BY_CARRIER = 2; // 0x2

public static final int MULTISIM_NOT_SUPPORTED_BY_HARDWARE = 1; // 0x1

public static final int NETWORK_SELECTION_MODE_AUTO = 1; // 0x1

public static final int NETWORK_SELECTION_MODE_MANUAL = 2; // 0x2

public static final int NETWORK_SELECTION_MODE_UNKNOWN = 0; // 0x0

public static final int NETWORK_TYPE_1xRTT = 7; // 0x7

public static final long NETWORK_TYPE_BITMASK_1xRTT = 64L; // 0x40L

public static final long NETWORK_TYPE_BITMASK_CDMA = 8L; // 0x8L

public static final long NETWORK_TYPE_BITMASK_EDGE = 2L; // 0x2L

public static final long NETWORK_TYPE_BITMASK_EHRPD = 8192L; // 0x2000L

public static final long NETWORK_TYPE_BITMASK_EVDO_0 = 16L; // 0x10L

public static final long NETWORK_TYPE_BITMASK_EVDO_A = 32L; // 0x20L

public static final long NETWORK_TYPE_BITMASK_EVDO_B = 2048L; // 0x800L

public static final long NETWORK_TYPE_BITMASK_GPRS = 1L; // 0x1L

public static final long NETWORK_TYPE_BITMASK_GSM = 32768L; // 0x8000L

public static final long NETWORK_TYPE_BITMASK_HSDPA = 128L; // 0x80L

public static final long NETWORK_TYPE_BITMASK_HSPA = 512L; // 0x200L

public static final long NETWORK_TYPE_BITMASK_HSPAP = 16384L; // 0x4000L

public static final long NETWORK_TYPE_BITMASK_HSUPA = 256L; // 0x100L

public static final long NETWORK_TYPE_BITMASK_IWLAN = 131072L; // 0x20000L

public static final long NETWORK_TYPE_BITMASK_LTE = 4096L; // 0x1000L

@Deprecated public static final long NETWORK_TYPE_BITMASK_LTE_CA = 262144L; // 0x40000L

public static final long NETWORK_TYPE_BITMASK_NR = 524288L; // 0x80000L

public static final long NETWORK_TYPE_BITMASK_TD_SCDMA = 65536L; // 0x10000L

public static final long NETWORK_TYPE_BITMASK_UMTS = 4L; // 0x4L

public static final long NETWORK_TYPE_BITMASK_UNKNOWN = 0L; // 0x0L

public static final int NETWORK_TYPE_CDMA = 4; // 0x4

public static final int NETWORK_TYPE_EDGE = 2; // 0x2

public static final int NETWORK_TYPE_EHRPD = 14; // 0xe

public static final int NETWORK_TYPE_EVDO_0 = 5; // 0x5

public static final int NETWORK_TYPE_EVDO_A = 6; // 0x6

public static final int NETWORK_TYPE_EVDO_B = 12; // 0xc

public static final int NETWORK_TYPE_GPRS = 1; // 0x1

public static final int NETWORK_TYPE_GSM = 16; // 0x10

public static final int NETWORK_TYPE_HSDPA = 8; // 0x8

public static final int NETWORK_TYPE_HSPA = 10; // 0xa

public static final int NETWORK_TYPE_HSPAP = 15; // 0xf

public static final int NETWORK_TYPE_HSUPA = 9; // 0x9

@Deprecated public static final int NETWORK_TYPE_IDEN = 11; // 0xb

public static final int NETWORK_TYPE_IWLAN = 18; // 0x12

public static final int NETWORK_TYPE_LTE = 13; // 0xd

public static final int NETWORK_TYPE_NR = 20; // 0x14

public static final int NETWORK_TYPE_TD_SCDMA = 17; // 0x11

public static final int NETWORK_TYPE_UMTS = 3; // 0x3

public static final int NETWORK_TYPE_UNKNOWN = 0; // 0x0

public static final int PHONE_TYPE_CDMA = 2; // 0x2

public static final int PHONE_TYPE_GSM = 1; // 0x1

public static final int PHONE_TYPE_NONE = 0; // 0x0

public static final int PHONE_TYPE_SIP = 3; // 0x3

public static final int PREMIUM_CAPABILITY_PRIORITIZE_LATENCY = 34; // 0x22

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_ALREADY_IN_PROGRESS = 4; // 0x4

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_ALREADY_PURCHASED = 3; // 0x3

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_CARRIER_DISABLED = 7; // 0x7

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_CARRIER_ERROR = 8; // 0x8

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_ENTITLEMENT_CHECK_FAILED = 13; // 0xd

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_FEATURE_NOT_SUPPORTED = 10; // 0xa

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_NETWORK_NOT_AVAILABLE = 12; // 0xc

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_NOT_DEFAULT_DATA_SUBSCRIPTION = 14; // 0xe

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_NOT_FOREGROUND = 5; // 0x5

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_PENDING_NETWORK_SETUP = 15; // 0xf

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_REQUEST_FAILED = 11; // 0xb

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_SUCCESS = 1; // 0x1

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_THROTTLED = 2; // 0x2

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_TIMEOUT = 9; // 0x9

public static final int PURCHASE_PREMIUM_CAPABILITY_RESULT_USER_CANCELED = 6; // 0x6

public static final int SET_OPPORTUNISTIC_SUB_INACTIVE_SUBSCRIPTION = 2; // 0x2

public static final int SET_OPPORTUNISTIC_SUB_NO_OPPORTUNISTIC_SUB_AVAILABLE = 3; // 0x3

public static final int SET_OPPORTUNISTIC_SUB_REMOTE_SERVICE_EXCEPTION = 4; // 0x4

public static final int SET_OPPORTUNISTIC_SUB_SUCCESS = 0; // 0x0

public static final int SET_OPPORTUNISTIC_SUB_VALIDATION_FAILED = 1; // 0x1

public static final int SIM_STATE_ABSENT = 1; // 0x1

public static final int SIM_STATE_CARD_IO_ERROR = 8; // 0x8

public static final int SIM_STATE_CARD_RESTRICTED = 9; // 0x9

public static final int SIM_STATE_NETWORK_LOCKED = 4; // 0x4

public static final int SIM_STATE_NOT_READY = 6; // 0x6

public static final int SIM_STATE_PERM_DISABLED = 7; // 0x7

public static final int SIM_STATE_PIN_REQUIRED = 2; // 0x2

public static final int SIM_STATE_PUK_REQUIRED = 3; // 0x3

public static final int SIM_STATE_READY = 5; // 0x5

public static final int SIM_STATE_UNKNOWN = 0; // 0x0

public static final int UNINITIALIZED_CARD_ID = -2; // 0xfffffffe

public static final int UNKNOWN_CARRIER_ID = -1; // 0xffffffff

public static final int UNSUPPORTED_CARD_ID = -1; // 0xffffffff

public static final int UPDATE_AVAILABLE_NETWORKS_ABORTED = 2; // 0x2

public static final int UPDATE_AVAILABLE_NETWORKS_DISABLE_MODEM_FAIL = 5; // 0x5

public static final int UPDATE_AVAILABLE_NETWORKS_ENABLE_MODEM_FAIL = 6; // 0x6

public static final int UPDATE_AVAILABLE_NETWORKS_INVALID_ARGUMENTS = 3; // 0x3

public static final int UPDATE_AVAILABLE_NETWORKS_MULTIPLE_NETWORKS_NOT_SUPPORTED = 7; // 0x7

public static final int UPDATE_AVAILABLE_NETWORKS_NO_CARRIER_PRIVILEGE = 4; // 0x4

public static final int UPDATE_AVAILABLE_NETWORKS_NO_OPPORTUNISTIC_SUB_AVAILABLE = 8; // 0x8

public static final int UPDATE_AVAILABLE_NETWORKS_REMOTE_SERVICE_EXCEPTION = 9; // 0x9

public static final int UPDATE_AVAILABLE_NETWORKS_SERVICE_IS_DISABLED = 10; // 0xa

public static final int UPDATE_AVAILABLE_NETWORKS_SUCCESS = 0; // 0x0

public static final int UPDATE_AVAILABLE_NETWORKS_UNKNOWN_FAILURE = 1; // 0x1

public static final int USSD_ERROR_SERVICE_UNAVAIL = -2; // 0xfffffffe

public static final int USSD_RETURN_FAILURE = -1; // 0xffffffff

public static final java.lang.String VVM_TYPE_CVVM = "vvm_type_cvvm";

public static final java.lang.String VVM_TYPE_OMTP = "vvm_type_omtp";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class CallComposerException extends java.lang.Exception {

public CallComposerException(int errorCode, @android.annotation.Nullable java.io.IOException ioException) { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.io.IOException getIOException() { throw new RuntimeException("Stub!"); }

public static final int ERROR_AUTHENTICATION_FAILED = 3; // 0x3

public static final int ERROR_FILE_TOO_LARGE = 2; // 0x2

public static final int ERROR_INPUT_CLOSED = 4; // 0x4

public static final int ERROR_IO_EXCEPTION = 5; // 0x5

public static final int ERROR_NETWORK_UNAVAILABLE = 6; // 0x6

public static final int ERROR_REMOTE_END_CLOSED = 1; // 0x1

public static final int ERROR_UNKNOWN = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class CellInfoCallback {

public CellInfoCallback() { throw new RuntimeException("Stub!"); }

public abstract void onCellInfo(@android.annotation.NonNull java.util.List<android.telephony.CellInfo> cellInfo);

public void onError(int errorCode, @android.annotation.Nullable java.lang.Throwable detail) { throw new RuntimeException("Stub!"); }

public static final int ERROR_MODEM_ERROR = 2; // 0x2

public static final int ERROR_TIMEOUT = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ModemErrorException extends android.telephony.TelephonyManager.NetworkSlicingException {

ModemErrorException() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class NetworkSlicingException extends java.lang.Exception {

NetworkSlicingException() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TimeoutException extends android.telephony.TelephonyManager.NetworkSlicingException {

TimeoutException() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class UssdResponseCallback {

public UssdResponseCallback() { throw new RuntimeException("Stub!"); }

public void onReceiveUssdResponse(android.telephony.TelephonyManager telephonyManager, java.lang.String request, java.lang.CharSequence response) { throw new RuntimeException("Stub!"); }

public void onReceiveUssdResponseFailed(android.telephony.TelephonyManager telephonyManager, java.lang.String request, int failureCode) { throw new RuntimeException("Stub!"); }
}

}

