/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * ChildSessionParams is an abstract class that represents proposed configurations for negotiating a
 * Child Session.
 *
 * <p>Note that references to negotiated configurations will be held, and the same parameters will
 * be reused during rekey. This includes SA Proposals, lifetimes and traffic selectors.
 *
 * <p>IKE library will send out KE payload only if user has configured one or more DH groups. The KE
 * payload in a request will use the first DH group from the first user provided SA proposal (or the
 * peer selected SA proposal if it's a rekey request). The KE payload in a response will depend on
 * the SA proposal negotiation result.
 *
 * <p>When requesting the first Child Session in IKE AUTH, IKE library will not propose any DH group
 * even if user has configured it, as per RFC 7296. When rekeying this child session, IKE library
 * will accept DH groups that are configured in its ChildSessionParams. If after rekeying user needs
 * to have the same DH group as that of the IKE Session, then they need to explicitly set the same
 * DH Group in ChildSessionParams.
 *
 * <p>@see {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} and {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ChildSessionParams {

ChildSessionParams() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configured inbound traffic selectors
 *
 * <p>@see {@link android.net.ipsec.ike.TunnelModeChildSessionParams.Builder#addInboundTrafficSelectors(android.net.ipsec.ike.IkeTrafficSelector)  } or
 * {@link android.net.ipsec.ike.TransportModeChildSessionParams.Builder#addInboundTrafficSelectors(android.net.ipsec.ike.IkeTrafficSelector)  }

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeTrafficSelector> getInboundTrafficSelectors() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configured outbound traffic selectors
 *
 * <p>@see {@link android.net.ipsec.ike.TunnelModeChildSessionParams.Builder#addOutboundTrafficSelectors(android.net.ipsec.ike.IkeTrafficSelector)  } or
 * {@link android.net.ipsec.ike.TransportModeChildSessionParams.Builder#addOutboundTrafficSelectors(android.net.ipsec.ike.IkeTrafficSelector)  }

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeTrafficSelector> getOutboundTrafficSelectors() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves all ChildSaProposals configured
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.ChildSaProposal> getChildSaProposals() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves hard lifetime in seconds
 * @return Value is between CHILD_HARD_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 */

public int getHardLifetimeSeconds() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves soft lifetime in seconds
 * @return Value is between CHILD_SOFT_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 */

public int getSoftLifetimeSeconds() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
}

