/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * ChildSessionConfiguration represents the negotiated configuration for a Child Session.
 *
 * <p>Configurations include traffic selectors and internal network information.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChildSessionConfiguration {

ChildSessionConfiguration() { throw new RuntimeException("Stub!"); }

/**
 * Returns the negotiated inbound traffic selectors.
 *
 * <p>Only inbound traffic within the range is acceptable to the Child Session.
 *
 * <p>The Android platform does not support port-based routing. Port ranges of traffic selectors
 * are only informational.
 *
 * @return the inbound traffic selectors.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeTrafficSelector> getInboundTrafficSelectors() { throw new RuntimeException("Stub!"); }

/**
 * Returns the negotiated outbound traffic selectors.
 *
 * <p>Only outbound traffic within the range is acceptable to the Child Session.
 *
 * <p>The Android platform does not support port-based routing. Port ranges of traffic selectors
 * are only informational.
 *
 * @return the outbound traffic selectors.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeTrafficSelector> getOutboundTrafficSelectors() { throw new RuntimeException("Stub!"); }
/**
 * This class can be used to incrementally construct a {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration}.
 *
 * <p>Except for testing, IKE library users normally do not instantiate {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} themselves but instead get a reference via {@link android.net.ipsec.ike.ChildSessionCallback ChildSessionCallback}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a Builder.
 *
 * @param inTs the negotiated inbound traffic selectors
 * This value cannot be {@code null}.
 * @param outTs the negotiated outbound traffic selectors

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.util.List<android.net.ipsec.ike.IkeTrafficSelector> inTs, @android.annotation.NonNull java.util.List<android.net.ipsec.ike.IkeTrafficSelector> outTs) { throw new RuntimeException("Stub!"); }

/**
 * Constructs an {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.ChildSessionConfiguration build() { throw new RuntimeException("Stub!"); }
}

}

