/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ProviderProperties implements android.os.Parcelable {

ProviderProperties() { throw new RuntimeException("Stub!"); }

public boolean hasNetworkRequirement() { throw new RuntimeException("Stub!"); }

public boolean hasSatelliteRequirement() { throw new RuntimeException("Stub!"); }

public boolean hasCellRequirement() { throw new RuntimeException("Stub!"); }

public boolean hasMonetaryCost() { throw new RuntimeException("Stub!"); }

public boolean hasAltitudeSupport() { throw new RuntimeException("Stub!"); }

public boolean hasSpeedSupport() { throw new RuntimeException("Stub!"); }

public boolean hasBearingSupport() { throw new RuntimeException("Stub!"); }

public int getPowerUsage() { throw new RuntimeException("Stub!"); }

public int getAccuracy() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int ACCURACY_COARSE = 2; // 0x2

public static final int ACCURACY_FINE = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.provider.ProviderProperties> CREATOR;
static { CREATOR = null; }

public static final int POWER_USAGE_HIGH = 3; // 0x3

public static final int POWER_USAGE_LOW = 1; // 0x1

public static final int POWER_USAGE_MEDIUM = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.location.provider.ProviderProperties providerProperties) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasNetworkRequirement(boolean requiresNetwork) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasSatelliteRequirement(boolean requiresSatellite) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasCellRequirement(boolean requiresCell) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasMonetaryCost(boolean monetaryCost) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasAltitudeSupport(boolean supportsAltitude) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasSpeedSupport(boolean supportsSpeed) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setHasBearingSupport(boolean supportsBearing) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setPowerUsage(int powerUsage) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties.Builder setAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.provider.ProviderProperties build() { throw new RuntimeException("Stub!"); }
}

}

