/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.changelog;

import android.health.connect.HealthConnectManager;

/**
 * A class to request changelog token using {@link android.health.connect.HealthConnectManager#getChangeLogToken HealthConnectManager#getChangeLogToken}
 *
 * @see android.health.connect.HealthConnectManager#getChangeLogToken
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChangeLogTokenRequest implements android.os.Parcelable {

ChangeLogTokenRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns list of package names corresponding to which the logs are required
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.health.connect.datatypes.DataOrigin> getDataOriginFilters() { throw new RuntimeException("Stub!"); }

/**
 * Returns list of record classes for which the logs are to be fetched
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Class<? extends android.health.connect.datatypes.Record>> getRecordTypes() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.changelog.ChangeLogTokenRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.health.connect.changelog.ChangeLogTokenRequest ChangeLogTokenRequest} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param recordType type of record for which change log is required. If not set includes
 *     all record types
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.changelog.ChangeLogTokenRequest.Builder addRecordType(@android.annotation.NonNull java.lang.Class<? extends android.health.connect.datatypes.Record> recordType) { throw new RuntimeException("Stub!"); }

/**
 * @param dataOriginFilter list of package names on which to filter the data.
 *     <p>If not set logs from all the sources will be returned
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.changelog.ChangeLogTokenRequest.Builder addDataOriginFilter(@android.annotation.NonNull android.health.connect.datatypes.DataOrigin dataOriginFilter) { throw new RuntimeException("Stub!"); }

/**
 * Returns Object of {@link android.health.connect.changelog.ChangeLogTokenRequest ChangeLogTokenRequest}
 *
 * @throws java.lang.IllegalArgumentException if record types are empty

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.changelog.ChangeLogTokenRequest build() { throw new RuntimeException("Stub!"); }
}

}

