/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;


/** Class representing health connect exceptions. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HealthConnectException extends java.lang.RuntimeException {

HealthConnectException() { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * Data sync is in progress. Data read and writes are blocked.
 *
 * <p>Caller should try this api call again later.
 */

public static final int ERROR_DATA_SYNC_IN_PROGRESS = 8; // 0x8

/**
 * An internal error occurred which the caller cannot address.
 *
 * <p>This error may be considered similar to {@link java.lang.IllegalStateException IllegalStateException}
 */

public static final int ERROR_INTERNAL = 2; // 0x2

/**
 * The caller supplied invalid arguments to the call.
 *
 * <p>This error may be considered similar to {@link java.lang.IllegalArgumentException IllegalArgumentException}.
 */

public static final int ERROR_INVALID_ARGUMENT = 3; // 0x3

/**
 * An issue occurred reading or writing to storage. The call might succeed if repeated.
 *
 * <p>This error may be considered similar to {@link java.io.IOException}.
 */

public static final int ERROR_IO = 4; // 0x4

/** The caller exhausted the allotted rate limit. */

public static final int ERROR_RATE_LIMIT_EXCEEDED = 7; // 0x7

/**
 * An IPC related error occurred.
 *
 * <p>This error may be considered similar to {@link android.os.RemoteException}.
 */

public static final int ERROR_REMOTE = 6; // 0x6

/**
 * The caller doesn't have the correct permissions for this call.
 *
 * <p>This error may be considered similar to {@link java.lang.SecurityException}.
 */

public static final int ERROR_SECURITY = 5; // 0x5

/** An unknown error occurred while processing the call. */

public static final int ERROR_UNKNOWN = 1; // 0x1

/**
 * This operation is currently not supported by the platform.
 *
 * <p>Caller may try this api call again later.
 */

public static final int ERROR_UNSUPPORTED_OPERATION = 9; // 0x9
}

