/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CameraExtensionSession implements java.lang.AutoCloseable {

CameraExtensionSession() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.camera2.CameraDevice getDevice() { throw new RuntimeException("Stub!"); }

public int capture(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraExtensionSession.ExtensionCaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public int setRepeatingRequest(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraExtensionSession.ExtensionCaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public void stopRepeating() throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.hardware.camera2.CameraExtensionSession.StillCaptureLatency getRealtimeStillCaptureLatency() throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public void close() throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class ExtensionCaptureCallback {

public ExtensionCaptureCallback() { throw new RuntimeException("Stub!"); }

public void onCaptureStarted(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, long timestamp) { throw new RuntimeException("Stub!"); }

public void onCaptureProcessStarted(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request) { throw new RuntimeException("Stub!"); }

public void onCaptureFailed(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request) { throw new RuntimeException("Stub!"); }

public void onCaptureSequenceCompleted(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, int sequenceId) { throw new RuntimeException("Stub!"); }

public void onCaptureSequenceAborted(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, int sequenceId) { throw new RuntimeException("Stub!"); }

public void onCaptureResultAvailable(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull android.hardware.camera2.TotalCaptureResult result) { throw new RuntimeException("Stub!"); }

public void onCaptureProcessProgressed(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, int progress) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class StateCallback {

public StateCallback() { throw new RuntimeException("Stub!"); }

public abstract void onConfigured(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session);

public abstract void onConfigureFailed(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session);

public void onClosed(@android.annotation.NonNull android.hardware.camera2.CameraExtensionSession session) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StillCaptureLatency {

public StillCaptureLatency(long captureLatency, long processingLatency) { throw new RuntimeException("Stub!"); }

public long getCaptureLatency() { throw new RuntimeException("Stub!"); }

public long getProcessingLatency() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

}

