/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.content.pm;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class PackageManager {

@Deprecated
public PackageManager() { throw new RuntimeException("Stub!"); }

public abstract android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public abstract android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull android.content.pm.VersionedPackage versionedPackage, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull android.content.pm.VersionedPackage versionedPackage, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public abstract java.lang.String[] currentToCanonicalPackageNames(@android.annotation.NonNull java.lang.String[] packageNames);

public abstract java.lang.String[] canonicalToCurrentPackageNames(@android.annotation.NonNull java.lang.String[] packageNames);

@android.annotation.Nullable
public abstract android.content.Intent getLaunchIntentForPackage(@android.annotation.NonNull java.lang.String packageName);

@android.annotation.Nullable
public abstract android.content.Intent getLeanbackLaunchIntentForPackage(@android.annotation.NonNull java.lang.String packageName);

@android.annotation.NonNull
public android.content.IntentSender getLaunchIntentSenderForPackage(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public abstract int[] getPackageGids(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract int[] getPackageGids(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public int[] getPackageGids(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public abstract int getPackageUid(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public int getPackageUid(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public abstract android.content.pm.PermissionInfo getPermissionInfo(@android.annotation.NonNull java.lang.String permName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PermissionInfo> queryPermissionsByGroup(@android.annotation.Nullable java.lang.String permissionGroup, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.pm.PermissionGroupInfo getPermissionGroupInfo(@android.annotation.NonNull java.lang.String groupName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PermissionGroupInfo> getAllPermissionGroups(int flags);

public void getPlatformPermissionsForGroup(@android.annotation.NonNull java.lang.String permissionGroupName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.util.List<java.lang.String>> callback) { throw new RuntimeException("Stub!"); }

public void getGroupOfPlatformPermission(@android.annotation.NonNull java.lang.String permissionName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.String> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ApplicationInfo getApplicationInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ApplicationInfo getApplicationInfo(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.content.pm.PackageManager.ApplicationInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public int getTargetSdkVersion(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ActivityInfo getActivityInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ActivityInfo getActivityInfo(@android.annotation.NonNull android.content.ComponentName component, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ActivityInfo getReceiverInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ActivityInfo getReceiverInfo(@android.annotation.NonNull android.content.ComponentName component, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ServiceInfo getServiceInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ServiceInfo getServiceInfo(@android.annotation.NonNull android.content.ComponentName component, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ProviderInfo getProviderInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ProviderInfo getProviderInfo(@android.annotation.NonNull android.content.ComponentName component, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.ModuleInfo getModuleInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.ModuleInfo> getInstalledModules(int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getInstalledPackages(int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInfo> getInstalledPackages(@android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getPackagesHoldingPermissions(@android.annotation.NonNull java.lang.String[] permissions, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageInfo> getPackagesHoldingPermissions(@android.annotation.NonNull java.lang.String[] permissions, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) { throw new RuntimeException("Stub!"); }

public abstract int checkPermission(@android.annotation.NonNull java.lang.String permName, @android.annotation.NonNull java.lang.String packageName);

public abstract boolean isPermissionRevokedByPolicy(@android.annotation.NonNull java.lang.String permName, @android.annotation.NonNull java.lang.String packageName);

public abstract boolean addPermission(@android.annotation.NonNull android.content.pm.PermissionInfo info);

public abstract boolean addPermissionAsync(@android.annotation.NonNull android.content.pm.PermissionInfo info);

public abstract void removePermission(@android.annotation.NonNull java.lang.String permName);

@android.annotation.NonNull
public java.util.Set<java.lang.String> getWhitelistedRestrictedPermissions(@android.annotation.NonNull java.lang.String packageName, int whitelistFlag) { throw new RuntimeException("Stub!"); }

public boolean addWhitelistedRestrictedPermission(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permName, int whitelistFlags) { throw new RuntimeException("Stub!"); }

public boolean removeWhitelistedRestrictedPermission(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permName, int whitelistFlags) { throw new RuntimeException("Stub!"); }

public boolean setAutoRevokeWhitelisted(@android.annotation.NonNull java.lang.String packageName, boolean whitelisted) { throw new RuntimeException("Stub!"); }

public boolean isAutoRevokeWhitelisted(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getBackgroundPermissionOptionLabel() { throw new RuntimeException("Stub!"); }

public abstract int checkSignatures(@android.annotation.NonNull java.lang.String packageName1, @android.annotation.NonNull java.lang.String packageName2);

public abstract int checkSignatures(int uid1, int uid2);

@android.annotation.Nullable
public abstract java.lang.String[] getPackagesForUid(int uid);

@android.annotation.Nullable
public abstract java.lang.String getNameForUid(int uid);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ApplicationInfo> getInstalledApplications(int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ApplicationInfo> getInstalledApplications(@android.annotation.NonNull android.content.pm.PackageManager.ApplicationInfoFlags flags) { throw new RuntimeException("Stub!"); }

public abstract boolean isInstantApp();

public abstract boolean isInstantApp(@android.annotation.NonNull java.lang.String packageName);

public abstract int getInstantAppCookieMaxBytes();

@android.annotation.NonNull
public abstract byte[] getInstantAppCookie();

public abstract void clearInstantAppCookie();

public abstract void updateInstantAppCookie(@android.annotation.Nullable byte[] cookie);

@android.annotation.Nullable
public abstract java.lang.String[] getSystemSharedLibraryNames();

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.SharedLibraryInfo> getSharedLibraries(int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.SharedLibraryInfo> getSharedLibraries(@android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.content.pm.ChangedPackages getChangedPackages(int sequenceNumber);

@android.annotation.NonNull
public abstract android.content.pm.FeatureInfo[] getSystemAvailableFeatures();

public abstract boolean hasSystemFeature(@android.annotation.NonNull java.lang.String featureName);

public abstract boolean hasSystemFeature(@android.annotation.NonNull java.lang.String featureName, int version);

@android.annotation.Nullable
public abstract android.content.pm.ResolveInfo resolveActivity(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.Nullable
public android.content.pm.ResolveInfo resolveActivity(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentActivities(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ResolveInfo> queryIntentActivities(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentActivityOptions(@android.annotation.Nullable android.content.ComponentName caller, @android.annotation.Nullable android.content.Intent[] specifics, @android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ResolveInfo> queryIntentActivityOptions(@android.annotation.Nullable android.content.ComponentName caller, @android.annotation.Nullable java.util.List<android.content.Intent> specifics, @android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryBroadcastReceivers(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ResolveInfo> queryBroadcastReceivers(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.content.pm.ResolveInfo resolveService(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.Nullable
public android.content.pm.ResolveInfo resolveService(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentServices(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ResolveInfo> queryIntentServices(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentContentProviders(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ResolveInfo> queryIntentContentProviders(@android.annotation.NonNull android.content.Intent intent, @android.annotation.NonNull android.content.pm.PackageManager.ResolveInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.content.pm.ProviderInfo resolveContentProvider(@android.annotation.NonNull java.lang.String authority, int flags);

@android.annotation.Nullable
public android.content.pm.ProviderInfo resolveContentProvider(@android.annotation.NonNull java.lang.String authority, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ProviderInfo> queryContentProviders(@android.annotation.Nullable java.lang.String processName, int uid, int flags);

@android.annotation.NonNull
public java.util.List<android.content.pm.ProviderInfo> queryContentProviders(@android.annotation.Nullable java.lang.String processName, int uid, @android.annotation.NonNull android.content.pm.PackageManager.ComponentInfoFlags flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.InstrumentationInfo getInstrumentationInfo(@android.annotation.NonNull android.content.ComponentName className, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.InstrumentationInfo> queryInstrumentation(@android.annotation.NonNull java.lang.String targetPackage, int flags);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getDrawable(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getActivityIcon(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getActivityIcon(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityBanner(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityBanner(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getDefaultActivityIcon();

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getApplicationIcon(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getApplicationIcon(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationBanner(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationBanner(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityLogo(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityLogo(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationLogo(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationLogo(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getUserBadgedIcon(@android.annotation.NonNull android.graphics.drawable.Drawable drawable, @android.annotation.NonNull android.os.UserHandle user);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getUserBadgedDrawableForDensity(@android.annotation.NonNull android.graphics.drawable.Drawable drawable, @android.annotation.NonNull android.os.UserHandle user, @android.annotation.Nullable android.graphics.Rect badgeLocation, int badgeDensity);

@android.annotation.NonNull
public abstract java.lang.CharSequence getUserBadgedLabel(@android.annotation.NonNull java.lang.CharSequence label, @android.annotation.NonNull android.os.UserHandle user);

@android.annotation.Nullable
public abstract java.lang.CharSequence getText(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.Nullable
public abstract android.content.res.XmlResourceParser getXml(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.NonNull
public abstract java.lang.CharSequence getApplicationLabel(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForActivity(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull android.content.pm.ApplicationInfo app) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull android.content.pm.ApplicationInfo app, @android.annotation.Nullable android.content.res.Configuration configuration) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public android.content.pm.PackageInfo getPackageArchiveInfo(@android.annotation.NonNull java.lang.String archiveFilePath, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.pm.PackageInfo getPackageArchiveInfo(@android.annotation.NonNull java.lang.String archiveFilePath, @android.annotation.NonNull android.content.pm.PackageManager.PackageInfoFlags flags) { throw new RuntimeException("Stub!"); }

public abstract void verifyPendingInstall(int id, int verificationCode);

public abstract void extendVerificationTimeout(int id, int verificationCodeAtTimeout, long millisecondsToDelay);

public abstract void setInstallerPackageName(@android.annotation.NonNull java.lang.String targetPackage, @android.annotation.Nullable java.lang.String installerPackageName);

@Deprecated
@android.annotation.Nullable
public abstract java.lang.String getInstallerPackageName(@android.annotation.NonNull java.lang.String packageName);

@android.annotation.NonNull
public android.content.pm.InstallSourceInfo getInstallSourceInfo(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract void addPackageToPreferred(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
public abstract void removePackageFromPreferred(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getPreferredPackages(int flags);

@Deprecated
public abstract void addPreferredActivity(@android.annotation.NonNull android.content.IntentFilter filter, int match, @android.annotation.Nullable android.content.ComponentName[] set, @android.annotation.NonNull android.content.ComponentName activity);

@Deprecated
public abstract void clearPackagePreferredActivities(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
public abstract int getPreferredActivities(@android.annotation.NonNull java.util.List<android.content.IntentFilter> outFilters, @android.annotation.NonNull java.util.List<android.content.ComponentName> outActivities, @android.annotation.Nullable java.lang.String packageName);

public abstract void setComponentEnabledSetting(@android.annotation.NonNull android.content.ComponentName componentName, int newState, int flags);

public void setComponentEnabledSettings(@android.annotation.NonNull java.util.List<android.content.pm.PackageManager.ComponentEnabledSetting> settings) { throw new RuntimeException("Stub!"); }

public abstract int getComponentEnabledSetting(@android.annotation.NonNull android.content.ComponentName componentName);

public boolean getSyntheticAppDetailsActivityEnabled(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public abstract void setApplicationEnabledSetting(@android.annotation.NonNull java.lang.String packageName, int newState, int flags);

public abstract int getApplicationEnabledSetting(@android.annotation.NonNull java.lang.String packageName);

public abstract boolean isSafeMode();

public boolean isPackageSuspended(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public boolean isPackageSuspended() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getSuspendedPackageAppExtras() { throw new RuntimeException("Stub!"); }

public abstract void setApplicationCategoryHint(@android.annotation.NonNull java.lang.String packageName, int categoryHint);

public boolean isDeviceUpgrading() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.PackageInstaller getPackageInstaller();

public abstract boolean canRequestPackageInstalls();

public boolean hasSigningCertificate(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull byte[] certificate, int type) { throw new RuntimeException("Stub!"); }

public boolean hasSigningCertificate(int uid, @android.annotation.NonNull byte[] certificate, int type) { throw new RuntimeException("Stub!"); }

public void requestChecksums(@android.annotation.NonNull java.lang.String packageName, boolean includeSplits, int required, @android.annotation.NonNull java.util.List<java.security.cert.Certificate> trustedInstallers, @android.annotation.NonNull android.content.pm.PackageManager.OnChecksumsReadyListener onChecksumsReadyListener) throws java.security.cert.CertificateEncodingException, android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public boolean isAutoRevokeWhitelisted() { throw new RuntimeException("Stub!"); }

public boolean isDefaultApplicationIcon(@android.annotation.NonNull android.graphics.drawable.Drawable drawable) { throw new RuntimeException("Stub!"); }

public void setMimeGroup(@android.annotation.NonNull java.lang.String mimeGroup, @android.annotation.NonNull java.util.Set<java.lang.String> mimeTypes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getMimeGroup(@android.annotation.NonNull java.lang.String mimeGroup) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageManager.Property getProperty(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageManager.Property getProperty(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull android.content.ComponentName component) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryApplicationProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryActivityProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryProviderProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryReceiverProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryServiceProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

public boolean canPackageQuery(@android.annotation.NonNull java.lang.String sourcePackageName, @android.annotation.NonNull java.lang.String targetPackageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public boolean[] canPackageQuery(@android.annotation.NonNull java.lang.String sourcePackageName, @android.annotation.NonNull java.lang.String[] targetPackageNames) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void relinquishUpdateOwnership(@android.annotation.NonNull java.lang.String targetPackage) { throw new RuntimeException("Stub!"); }

public static final int CERT_INPUT_RAW_X509 = 0; // 0x0

public static final int CERT_INPUT_SHA256 = 1; // 0x1

public static final int COMPONENT_ENABLED_STATE_DEFAULT = 0; // 0x0

public static final int COMPONENT_ENABLED_STATE_DISABLED = 2; // 0x2

public static final int COMPONENT_ENABLED_STATE_DISABLED_UNTIL_USED = 4; // 0x4

public static final int COMPONENT_ENABLED_STATE_DISABLED_USER = 3; // 0x3

public static final int COMPONENT_ENABLED_STATE_ENABLED = 1; // 0x1

public static final int DONT_KILL_APP = 1; // 0x1

public static final java.lang.String EXTRA_VERIFICATION_ID = "android.content.pm.extra.VERIFICATION_ID";

public static final java.lang.String EXTRA_VERIFICATION_RESULT = "android.content.pm.extra.VERIFICATION_RESULT";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_ACTIVITIES_ON_SECONDARY_DISPLAYS = "android.software.activities_on_secondary_displays";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_APP_WIDGETS = "android.software.app_widgets";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_AUDIO_LOW_LATENCY = "android.hardware.audio.low_latency";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_AUDIO_OUTPUT = "android.hardware.audio.output";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_AUDIO_PRO = "android.hardware.audio.pro";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_AUTOFILL = "android.software.autofill";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_AUTOMOTIVE = "android.hardware.type.automotive";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_BACKUP = "android.software.backup";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_BLUETOOTH = "android.hardware.bluetooth";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_BLUETOOTH_LE = "android.hardware.bluetooth_le";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA = "android.hardware.camera";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_ANY = "android.hardware.camera.any";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_AR = "android.hardware.camera.ar";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_AUTOFOCUS = "android.hardware.camera.autofocus";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_CAPABILITY_MANUAL_POST_PROCESSING = "android.hardware.camera.capability.manual_post_processing";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_CAPABILITY_MANUAL_SENSOR = "android.hardware.camera.capability.manual_sensor";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_CAPABILITY_RAW = "android.hardware.camera.capability.raw";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_CONCURRENT = "android.hardware.camera.concurrent";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_EXTERNAL = "android.hardware.camera.external";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_FLASH = "android.hardware.camera.flash";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_FRONT = "android.hardware.camera.front";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CAMERA_LEVEL_FULL = "android.hardware.camera.level.full";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CANT_SAVE_STATE = "android.software.cant_save_state";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_COMPANION_DEVICE_SETUP = "android.software.companion_device_setup";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CONNECTION_SERVICE = "android.software.connectionservice";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CONSUMER_IR = "android.hardware.consumerir";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CONTROLS = "android.software.controls";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_CREDENTIALS = "android.software.credentials";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_DEVICE_ADMIN = "android.software.device_admin";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_DEVICE_LOCK = "android.software.device_lock";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_EMBEDDED = "android.hardware.type.embedded";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_ETHERNET = "android.hardware.ethernet";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_EXPANDED_PICTURE_IN_PICTURE = "android.software.expanded_picture_in_picture";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FACE = "android.hardware.biometrics.face";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FAKETOUCH = "android.hardware.faketouch";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FAKETOUCH_MULTITOUCH_DISTINCT = "android.hardware.faketouch.multitouch.distinct";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FAKETOUCH_MULTITOUCH_JAZZHAND = "android.hardware.faketouch.multitouch.jazzhand";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FINGERPRINT = "android.hardware.fingerprint";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_FREEFORM_WINDOW_MANAGEMENT = "android.software.freeform_window_management";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_GAMEPAD = "android.hardware.gamepad";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_HARDWARE_KEYSTORE = "android.hardware.hardware_keystore";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_HIFI_SENSORS = "android.hardware.sensor.hifi_sensors";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_HOME_SCREEN = "android.software.home_screen";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_IDENTITY_CREDENTIAL_HARDWARE = "android.hardware.identity_credential";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_IDENTITY_CREDENTIAL_HARDWARE_DIRECT_ACCESS = "android.hardware.identity_credential_direct_access";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_INPUT_METHODS = "android.software.input_methods";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_IPSEC_TUNNELS = "android.software.ipsec_tunnels";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_IPSEC_TUNNEL_MIGRATION = "android.software.ipsec_tunnel_migration";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_IRIS = "android.hardware.biometrics.iris";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_KEYSTORE_APP_ATTEST_KEY = "android.hardware.keystore.app_attest_key";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_KEYSTORE_LIMITED_USE_KEY = "android.hardware.keystore.limited_use_key";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_KEYSTORE_SINGLE_USE_KEY = "android.hardware.keystore.single_use_key";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LEANBACK = "android.software.leanback";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LEANBACK_ONLY = "android.software.leanback_only";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LIVE_TV = "android.software.live_tv";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LIVE_WALLPAPER = "android.software.live_wallpaper";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LOCATION = "android.hardware.location";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LOCATION_GPS = "android.hardware.location.gps";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_LOCATION_NETWORK = "android.hardware.location.network";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_MANAGED_USERS = "android.software.managed_users";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_MICROPHONE = "android.hardware.microphone";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_MIDI = "android.software.midi";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC = "android.hardware.nfc";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC_BEAM = "android.sofware.nfc.beam";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC_HOST_CARD_EMULATION = "android.hardware.nfc.hce";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC_HOST_CARD_EMULATION_NFCF = "android.hardware.nfc.hcef";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC_OFF_HOST_CARD_EMULATION_ESE = "android.hardware.nfc.ese";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_NFC_OFF_HOST_CARD_EMULATION_UICC = "android.hardware.nfc.uicc";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_OPENGLES_DEQP_LEVEL = "android.software.opengles.deqp.level";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_OPENGLES_EXTENSION_PACK = "android.hardware.opengles.aep";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_PC = "android.hardware.type.pc";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_PICTURE_IN_PICTURE = "android.software.picture_in_picture";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_PRINTING = "android.software.print";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_RAM_LOW = "android.hardware.ram.low";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_RAM_NORMAL = "android.hardware.ram.normal";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SCREEN_LANDSCAPE = "android.hardware.screen.landscape";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SCREEN_PORTRAIT = "android.hardware.screen.portrait";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SECURELY_REMOVES_USERS = "android.software.securely_removes_users";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SECURE_LOCK_SCREEN = "android.software.secure_lock_screen";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SECURITY_MODEL_COMPATIBLE = "android.hardware.security.model.compatible";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_ACCELEROMETER = "android.hardware.sensor.accelerometer";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_ACCELEROMETER_LIMITED_AXES = "android.hardware.sensor.accelerometer_limited_axes";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_ACCELEROMETER_LIMITED_AXES_UNCALIBRATED = "android.hardware.sensor.accelerometer_limited_axes_uncalibrated";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_AMBIENT_TEMPERATURE = "android.hardware.sensor.ambient_temperature";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_BAROMETER = "android.hardware.sensor.barometer";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_COMPASS = "android.hardware.sensor.compass";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_DYNAMIC_HEAD_TRACKER = "android.hardware.sensor.dynamic.head_tracker";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_GYROSCOPE = "android.hardware.sensor.gyroscope";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_GYROSCOPE_LIMITED_AXES = "android.hardware.sensor.gyroscope_limited_axes";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_GYROSCOPE_LIMITED_AXES_UNCALIBRATED = "android.hardware.sensor.gyroscope_limited_axes_uncalibrated";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_HEADING = "android.hardware.sensor.heading";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_HEART_RATE = "android.hardware.sensor.heartrate";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_HEART_RATE_ECG = "android.hardware.sensor.heartrate.ecg";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_HINGE_ANGLE = "android.hardware.sensor.hinge_angle";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_LIGHT = "android.hardware.sensor.light";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_PROXIMITY = "android.hardware.sensor.proximity";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_RELATIVE_HUMIDITY = "android.hardware.sensor.relative_humidity";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_STEP_COUNTER = "android.hardware.sensor.stepcounter";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SENSOR_STEP_DETECTOR = "android.hardware.sensor.stepdetector";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SE_OMAPI_ESE = "android.hardware.se.omapi.ese";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SE_OMAPI_SD = "android.hardware.se.omapi.sd";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SE_OMAPI_UICC = "android.hardware.se.omapi.uicc";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SIP = "android.software.sip";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_SIP_VOIP = "android.software.sip.voip";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_STRONGBOX_KEYSTORE = "android.hardware.strongbox_keystore";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELECOM = "android.software.telecom";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY = "android.hardware.telephony";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_CALLING = "android.hardware.telephony.calling";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_CDMA = "android.hardware.telephony.cdma";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_DATA = "android.hardware.telephony.data";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_EUICC = "android.hardware.telephony.euicc";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_EUICC_MEP = "android.hardware.telephony.euicc.mep";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_GSM = "android.hardware.telephony.gsm";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_IMS = "android.hardware.telephony.ims";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_MBMS = "android.hardware.telephony.mbms";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_MESSAGING = "android.hardware.telephony.messaging";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_RADIO_ACCESS = "android.hardware.telephony.radio.access";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEPHONY_SUBSCRIPTION = "android.hardware.telephony.subscription";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TELEVISION = "android.hardware.type.television";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TOUCHSCREEN = "android.hardware.touchscreen";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH = "android.hardware.touchscreen.multitouch";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH_DISTINCT = "android.hardware.touchscreen.multitouch.distinct";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH_JAZZHAND = "android.hardware.touchscreen.multitouch.jazzhand";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_USB_ACCESSORY = "android.hardware.usb.accessory";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_USB_HOST = "android.hardware.usb.host";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_UWB = "android.hardware.uwb";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VERIFIED_BOOT = "android.software.verified_boot";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VR_HEADTRACKING = "android.hardware.vr.headtracking";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VR_MODE = "android.software.vr.mode";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VR_MODE_HIGH_PERFORMANCE = "android.hardware.vr.high_performance";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VULKAN_DEQP_LEVEL = "android.software.vulkan.deqp.level";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VULKAN_HARDWARE_COMPUTE = "android.hardware.vulkan.compute";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VULKAN_HARDWARE_LEVEL = "android.hardware.vulkan.level";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_VULKAN_HARDWARE_VERSION = "android.hardware.vulkan.version";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WALLET_LOCATION_BASED_SUGGESTIONS = "android.software.wallet_location_based_suggestions";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WATCH = "android.hardware.type.watch";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WEBVIEW = "android.software.webview";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WIFI = "android.hardware.wifi";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WIFI_AWARE = "android.hardware.wifi.aware";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WIFI_DIRECT = "android.hardware.wifi.direct";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WIFI_PASSPOINT = "android.hardware.wifi.passpoint";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WIFI_RTT = "android.hardware.wifi.rtt";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.FEATURE) public static final java.lang.String FEATURE_WINDOW_MAGNIFICATION = "android.software.window_magnification";

public static final int FLAG_PERMISSION_WHITELIST_INSTALLER = 2; // 0x2

public static final int FLAG_PERMISSION_WHITELIST_SYSTEM = 1; // 0x1

public static final int FLAG_PERMISSION_WHITELIST_UPGRADE = 4; // 0x4

public static final int GET_ACTIVITIES = 1; // 0x1

@Deprecated public static final int GET_ATTRIBUTIONS = -2147483648; // 0x80000000

public static final long GET_ATTRIBUTIONS_LONG = 2147483648L; // 0x80000000L

public static final int GET_CONFIGURATIONS = 16384; // 0x4000

@Deprecated public static final int GET_DISABLED_COMPONENTS = 512; // 0x200

@Deprecated public static final int GET_DISABLED_UNTIL_USED_COMPONENTS = 32768; // 0x8000

public static final int GET_GIDS = 256; // 0x100

public static final int GET_INSTRUMENTATION = 16; // 0x10

@Deprecated public static final int GET_INTENT_FILTERS = 32; // 0x20

public static final int GET_META_DATA = 128; // 0x80

public static final int GET_PERMISSIONS = 4096; // 0x1000

public static final int GET_PROVIDERS = 8; // 0x8

public static final int GET_RECEIVERS = 2; // 0x2

public static final int GET_RESOLVED_FILTER = 64; // 0x40

public static final int GET_SERVICES = 4; // 0x4

public static final int GET_SHARED_LIBRARY_FILES = 1024; // 0x400

@Deprecated public static final int GET_SIGNATURES = 64; // 0x40

public static final int GET_SIGNING_CERTIFICATES = 134217728; // 0x8000000

@Deprecated public static final int GET_UNINSTALLED_PACKAGES = 8192; // 0x2000

public static final int GET_URI_PERMISSION_PATTERNS = 2048; // 0x800

public static final int INSTALL_REASON_DEVICE_RESTORE = 2; // 0x2

public static final int INSTALL_REASON_DEVICE_SETUP = 3; // 0x3

public static final int INSTALL_REASON_POLICY = 1; // 0x1

public static final int INSTALL_REASON_UNKNOWN = 0; // 0x0

public static final int INSTALL_REASON_USER = 4; // 0x4

public static final int INSTALL_SCENARIO_BULK = 2; // 0x2

public static final int INSTALL_SCENARIO_BULK_SECONDARY = 3; // 0x3

public static final int INSTALL_SCENARIO_DEFAULT = 0; // 0x0

public static final int INSTALL_SCENARIO_FAST = 1; // 0x1

public static final int MATCH_ALL = 131072; // 0x20000

public static final int MATCH_APEX = 1073741824; // 0x40000000

public static final int MATCH_DEFAULT_ONLY = 65536; // 0x10000

public static final int MATCH_DIRECT_BOOT_AUTO = 268435456; // 0x10000000

public static final int MATCH_DIRECT_BOOT_AWARE = 524288; // 0x80000

public static final int MATCH_DIRECT_BOOT_UNAWARE = 262144; // 0x40000

public static final int MATCH_DISABLED_COMPONENTS = 512; // 0x200

public static final int MATCH_DISABLED_UNTIL_USED_COMPONENTS = 32768; // 0x8000

public static final int MATCH_SYSTEM_ONLY = 1048576; // 0x100000

public static final int MATCH_UNINSTALLED_PACKAGES = 8192; // 0x2000

public static final long MAXIMUM_VERIFICATION_TIMEOUT = 3600000L; // 0x36ee80L

public static final int PERMISSION_DENIED = -1; // 0xffffffff

public static final int PERMISSION_GRANTED = 0; // 0x0

public static final java.lang.String PROPERTY_COMPAT_OVERRIDE_LANDSCAPE_TO_PORTRAIT = "android.camera.PROPERTY_COMPAT_OVERRIDE_LANDSCAPE_TO_PORTRAIT";

public static final java.lang.String PROPERTY_MEDIA_CAPABILITIES = "android.media.PROPERTY_MEDIA_CAPABILITIES";

public static final java.lang.String PROPERTY_SELF_CERTIFIED_NETWORK_CAPABILITIES = "android.net.PROPERTY_SELF_CERTIFIED_NETWORK_CAPABILITIES";

public static final java.lang.String PROPERTY_SPECIAL_USE_FGS_SUBTYPE = "android.app.PROPERTY_SPECIAL_USE_FGS_SUBTYPE";

public static final int SIGNATURE_FIRST_NOT_SIGNED = -1; // 0xffffffff

public static final int SIGNATURE_MATCH = 0; // 0x0

public static final int SIGNATURE_NEITHER_SIGNED = 1; // 0x1

public static final int SIGNATURE_NO_MATCH = -3; // 0xfffffffd

public static final int SIGNATURE_SECOND_NOT_SIGNED = -2; // 0xfffffffe

public static final int SIGNATURE_UNKNOWN_PACKAGE = -4; // 0xfffffffc

public static final int SYNCHRONOUS = 2; // 0x2

@android.annotation.NonNull public static final java.util.List<java.security.cert.Certificate> TRUST_ALL;
static { TRUST_ALL = null; }

@android.annotation.NonNull public static final java.util.List<java.security.cert.Certificate> TRUST_NONE;
static { TRUST_NONE = null; }

public static final int VERIFICATION_ALLOW = 1; // 0x1

public static final int VERIFICATION_REJECT = -1; // 0xffffffff

public static final int VERSION_CODE_HIGHEST = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ApplicationInfoFlags {

ApplicationInfoFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageManager.ApplicationInfoFlags of(long value) { throw new RuntimeException("Stub!"); }

public long getValue() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ComponentEnabledSetting implements android.os.Parcelable {

public ComponentEnabledSetting(@android.annotation.NonNull android.content.ComponentName componentName, int newState, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.ComponentName getComponentName() { throw new RuntimeException("Stub!"); }

public int getEnabledState() { throw new RuntimeException("Stub!"); }

public int getEnabledFlags() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageManager.ComponentEnabledSetting> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ComponentInfoFlags {

ComponentInfoFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageManager.ComponentInfoFlags of(long value) { throw new RuntimeException("Stub!"); }

public long getValue() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class NameNotFoundException extends android.util.AndroidException {

public NameNotFoundException() { throw new RuntimeException("Stub!"); }

public NameNotFoundException(java.lang.String name) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public static interface OnChecksumsReadyListener {

public void onChecksumsReady(@android.annotation.NonNull java.util.List<android.content.pm.ApkChecksum> checksums);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PackageInfoFlags {

PackageInfoFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageManager.PackageInfoFlags of(long value) { throw new RuntimeException("Stub!"); }

public long getValue() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Property implements android.os.Parcelable {

Property() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getClassName() { throw new RuntimeException("Stub!"); }

public boolean getBoolean() { throw new RuntimeException("Stub!"); }

public boolean isBoolean() { throw new RuntimeException("Stub!"); }

public float getFloat() { throw new RuntimeException("Stub!"); }

public boolean isFloat() { throw new RuntimeException("Stub!"); }

public int getInteger() { throw new RuntimeException("Stub!"); }

public boolean isInteger() { throw new RuntimeException("Stub!"); }

public int getResourceId() { throw new RuntimeException("Stub!"); }

public boolean isResourceId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getString() { throw new RuntimeException("Stub!"); }

public boolean isString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageManager.Property> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ResolveInfoFlags {

ResolveInfoFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.content.pm.PackageManager.ResolveInfoFlags of(long value) { throw new RuntimeException("Stub!"); }

public long getValue() { throw new RuntimeException("Stub!"); }
}

}

