/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;

import android.os.Bundle;

/** Exception thrown by {@link android.app.sdksandbox.SdkSandboxManager#loadSdk SdkSandboxManager#loadSdk} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LoadSdkException extends java.lang.Exception implements android.os.Parcelable {

/**
 * Initializes a {@link android.app.sdksandbox.LoadSdkException LoadSdkException} with a Throwable and a Bundle.
 *
 * @param cause The cause of the exception, which is saved for later retrieval by the {@link
 *     #getCause()} method.
 * This value cannot be {@code null}.
 * @param extraInfo Extra error information. This is empty if there is no such information.

 * This value cannot be {@code null}.
 */

public LoadSdkException(@android.annotation.NonNull java.lang.Throwable cause, @android.annotation.NonNull android.os.Bundle extraInfo) { throw new RuntimeException("Stub!"); }

/**
 * Returns the result code this exception was constructed with.
 *
 * @return The loadSdk result code.

 * Value is {@link android.app.sdksandbox.SdkSandboxManager#LOAD_SDK_NOT_FOUND}, {@link android.app.sdksandbox.SdkSandboxManager#LOAD_SDK_ALREADY_LOADED}, {@link android.app.sdksandbox.SdkSandboxManager#LOAD_SDK_SDK_DEFINED_ERROR}, {@link android.app.sdksandbox.SdkSandboxManager#LOAD_SDK_SDK_SANDBOX_DISABLED}, {@link android.app.sdksandbox.SdkSandboxManager#LOAD_SDK_INTERNAL_ERROR}, or {@link android.app.sdksandbox.SdkSandboxManager#SDK_SANDBOX_PROCESS_NOT_AVAILABLE}
 */

public int getLoadSdkErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the extra error information this exception was constructed with.
 *
 * @return The extra error information Bundle.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.Bundle getExtraInformation() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param destination This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel destination, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.sdksandbox.LoadSdkException> CREATOR;
static { CREATOR = null; }
}

