/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.topics;


/** Get Topics Request. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetTopicsRequest {

GetTopicsRequest() { throw new RuntimeException("Stub!"); }

/**
 * Get the Sdk Name.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAdsSdkName() { throw new RuntimeException("Stub!"); }

/** Get Record Observation. */

public boolean shouldRecordObservation() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.topics.GetTopicsRequest GetTopicsRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a {@link android.adservices.topics.GetTopicsRequest.Builder Builder} for {@link android.adservices.topics.GetTopicsRequest GetTopicsRequest} objects. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set Ads Sdk Name.
 *
 * <p>This must be called by SDKs running outside of the Sandbox. Other clients must not
 * call it.
 *
 * @param adsSdkName the Ads Sdk Name.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.topics.GetTopicsRequest.Builder setAdsSdkName(@android.annotation.NonNull java.lang.String adsSdkName) { throw new RuntimeException("Stub!"); }

/**
 * Set the Record Observation.
 *
 * @param recordObservation whether to record that the caller has observed the topics of the
 *     host app or not. This will be used to determine if the caller can receive the topic
 *     in the next epoch.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.topics.GetTopicsRequest.Builder setShouldRecordObservation(boolean recordObservation) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.topics.GetTopicsRequest GetTopicsRequest} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.topics.GetTopicsRequest build() { throw new RuntimeException("Stub!"); }
}

}

