/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv.interactive;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TvInteractiveAppManager {

TvInteractiveAppManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.tv.interactive.TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList() { throw new RuntimeException("Stub!"); }

public void registerAppLinkInfo(@android.annotation.NonNull java.lang.String tvIAppServiceId, @android.annotation.NonNull android.media.tv.interactive.AppLinkInfo appLinkInfo) { throw new RuntimeException("Stub!"); }

public void unregisterAppLinkInfo(@android.annotation.NonNull java.lang.String tvIAppServiceId, @android.annotation.NonNull android.media.tv.interactive.AppLinkInfo appLinkInfo) { throw new RuntimeException("Stub!"); }

public void sendAppLinkCommand(@android.annotation.NonNull java.lang.String tvIAppServiceId, @android.annotation.NonNull android.os.Bundle command) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.tv.interactive.TvInteractiveAppManager.TvInteractiveAppCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.media.tv.interactive.TvInteractiveAppManager.TvInteractiveAppCallback callback) { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_APP_LINK_COMMAND = "android.media.tv.interactive.action.APP_LINK_COMMAND";

public static final java.lang.String APP_LINK_KEY_BACK_URI = "back_uri";

public static final java.lang.String APP_LINK_KEY_CLASS_NAME = "class_name";

public static final java.lang.String APP_LINK_KEY_COMMAND_TYPE = "command_type";

public static final java.lang.String APP_LINK_KEY_PACKAGE_NAME = "package_name";

public static final java.lang.String APP_LINK_KEY_SERVICE_ID = "service_id";

public static final int ERROR_BLOCKED = 5; // 0x5

public static final int ERROR_ENCRYPTED = 6; // 0x6

public static final int ERROR_NONE = 0; // 0x0

public static final int ERROR_NOT_SUPPORTED = 2; // 0x2

public static final int ERROR_RESOURCE_UNAVAILABLE = 4; // 0x4

public static final int ERROR_UNKNOWN = 1; // 0x1

public static final int ERROR_UNKNOWN_CHANNEL = 7; // 0x7

public static final int ERROR_WEAK_SIGNAL = 3; // 0x3

public static final java.lang.String INTENT_KEY_BI_INTERACTIVE_APP_TYPE = "bi_interactive_app_type";

public static final java.lang.String INTENT_KEY_BI_INTERACTIVE_APP_URI = "bi_interactive_app_uri";

public static final java.lang.String INTENT_KEY_CHANNEL_URI = "channel_uri";

public static final java.lang.String INTENT_KEY_COMMAND_TYPE = "command_type";

public static final java.lang.String INTENT_KEY_INTERACTIVE_APP_SERVICE_ID = "interactive_app_id";

public static final java.lang.String INTENT_KEY_TV_INPUT_ID = "tv_input_id";

public static final int INTERACTIVE_APP_STATE_ERROR = 3; // 0x3

public static final int INTERACTIVE_APP_STATE_RUNNING = 2; // 0x2

public static final int INTERACTIVE_APP_STATE_STOPPED = 1; // 0x1

public static final int SERVICE_STATE_ERROR = 4; // 0x4

public static final int SERVICE_STATE_PREPARING = 2; // 0x2

public static final int SERVICE_STATE_READY = 3; // 0x3

public static final int SERVICE_STATE_UNREALIZED = 1; // 0x1

public static final int TELETEXT_APP_STATE_ERROR = 3; // 0x3

public static final int TELETEXT_APP_STATE_HIDE = 2; // 0x2

public static final int TELETEXT_APP_STATE_SHOW = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class TvInteractiveAppCallback {

public TvInteractiveAppCallback() { throw new RuntimeException("Stub!"); }

public void onInteractiveAppServiceAdded(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onInteractiveAppServiceRemoved(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onInteractiveAppServiceUpdated(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onTvInteractiveAppServiceStateChanged(@android.annotation.NonNull java.lang.String iAppServiceId, int type, int state, int err) { throw new RuntimeException("Stub!"); }
}

}

