/*
 * Copyright 2020 HIMSA II K/S - www.himsa.com.
 * Represented by EHIMA - www.ehima.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * This class provides the public APIs to control the LeAudio profile.
 *
 * <p>BluetoothLeAudio is a proxy object for controlling the Bluetooth LE Audio
 * Service via IPC. Use {@link android.bluetooth.BluetoothAdapter#getProfileProxy BluetoothAdapter#getProfileProxy} to get
 * the BluetoothLeAudio proxy object.
 *
 * <p> Android only supports one set of connected Bluetooth LeAudio device at a time. Each
 * method is protected with its appropriate permission.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeAudio implements android.bluetooth.BluetoothProfile, java.lang.AutoCloseable {

BluetoothLeAudio() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

/**
 * Get Lead device for the group.
 *
 * Lead device is the device that can be used as an active device in the system.
 * Active devices points to the Audio Device for the Le Audio group.
 * This method returns the Lead devices for the connected LE Audio
 * group and this device should be used in the setActiveDevice() method by other parts
 * of the system, which wants to set to active a particular Le Audio group.
 *
 * Note: getActiveDevice() returns the Lead device for the currently active LE Audio group.
 * Note: When Lead device gets disconnected while Le Audio group is active and has more devices
 * in the group, then Lead device will not change. If Lead device gets disconnected, for the
 * Le Audio group which is not active, a new Lead device will be chosen
 *
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 * @param groupId The group id.
 * @return group lead device.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.bluetooth.BluetoothDevice getConnectedGroupLeadDevice(int groupId) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.
 
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.
 
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 
 * @param states This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(@android.annotation.NonNull int[] states) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES#R} or lower, this
 * requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission#BLUETOOTH} permission
 * which can be gained with a simple {@code <uses-permission>}
 * manifest tag.
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.
 
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 
 * @param device This value cannot be {@code null}.
 * @return Value is {@link android.bluetooth.BluetoothProfile#STATE_DISCONNECTED}, {@link android.bluetooth.BluetoothProfile#STATE_CONNECTING}, {@link android.bluetooth.BluetoothProfile#STATE_CONNECTED}, or {@link android.bluetooth.BluetoothProfile#STATE_DISCONNECTING}
 */

public int getConnectionState(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

/**
 * Get device group id. Devices with same group id belong to same group (i.e left and right
 * earbud)
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES#R} or lower, this
 * requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission#BLUETOOTH} permission
 * which can be gained with a simple {@code <uses-permission>}
 * manifest tag.
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 * @param device LE Audio capable device
 * This value cannot be {@code null}.
 * @return group id that this device currently belongs to, {@link #GROUP_ID_INVALID} when this
 *         device does not belong to any group
 */

public int getGroupId(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

/**
 * Intent used to broadcast the change in connection state of the LeAudio
 * profile. Please note that in the binaural case, there will be two different LE devices for
 * the left and right side and each device will have their own connection state changes.
 *
 * <p>This intent will have 3 extras:
 * <ul>
 * <li> {@link #EXTRA_STATE} - The current state of the profile. </li>
 * <li> {@link #EXTRA_PREVIOUS_STATE}- The previous state of the profile.</li>
 * <li> {@link android.bluetooth.BluetoothDevice#EXTRA_DEVICE BluetoothDevice#EXTRA_DEVICE} - The remote device. </li>
 * </ul>
 *
 * <p>{@link #EXTRA_STATE} or {@link #EXTRA_PREVIOUS_STATE} can be any of
 * {@link #STATE_DISCONNECTED}, {@link #STATE_CONNECTING},
 * {@link #STATE_CONNECTED}, {@link #STATE_DISCONNECTING}.

 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES#R} or lower, this
 * requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission#BLUETOOTH} permission
 * which can be gained with a simple {@code <uses-permission>}
 * manifest tag.
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES#S} or or higher,
 * this requires the {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission#BLUETOOTH_CONNECT}
 * permission which can be gained with
 * {@link android.app.Activity#requestPermissions(String[], int)}.

 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_LE_AUDIO_CONNECTION_STATE_CHANGED = "android.bluetooth.action.LE_AUDIO_CONNECTION_STATE_CHANGED";

/**
 * This represents an invalid group ID.
 */

public static final int GROUP_ID_INVALID = -1; // 0xffffffff
}

