/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.biometrics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BiometricPrompt {

private BiometricPrompt() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getSubtitle() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getDescription() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getNegativeButtonText() { throw new RuntimeException("Stub!"); }

public boolean isConfirmationRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public int getAllowedAuthenticators() { throw new RuntimeException("Stub!"); }

public void authenticate(@android.annotation.NonNull android.hardware.biometrics.BiometricPrompt.CryptoObject crypto, @android.annotation.NonNull android.os.CancellationSignal cancel, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.biometrics.BiometricPrompt.AuthenticationCallback callback) { throw new RuntimeException("Stub!"); }

public void authenticate(@android.annotation.NonNull android.os.CancellationSignal cancel, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.biometrics.BiometricPrompt.AuthenticationCallback callback) { throw new RuntimeException("Stub!"); }

public static final int AUTHENTICATION_RESULT_TYPE_BIOMETRIC = 2; // 0x2

public static final int AUTHENTICATION_RESULT_TYPE_DEVICE_CREDENTIAL = 1; // 0x1

public static final int BIOMETRIC_ACQUIRED_GOOD = 0; // 0x0

public static final int BIOMETRIC_ACQUIRED_IMAGER_DIRTY = 3; // 0x3

public static final int BIOMETRIC_ACQUIRED_INSUFFICIENT = 2; // 0x2

public static final int BIOMETRIC_ACQUIRED_PARTIAL = 1; // 0x1

public static final int BIOMETRIC_ACQUIRED_TOO_FAST = 5; // 0x5

public static final int BIOMETRIC_ACQUIRED_TOO_SLOW = 4; // 0x4

public static final int BIOMETRIC_ERROR_CANCELED = 5; // 0x5

public static final int BIOMETRIC_ERROR_HW_NOT_PRESENT = 12; // 0xc

public static final int BIOMETRIC_ERROR_HW_UNAVAILABLE = 1; // 0x1

public static final int BIOMETRIC_ERROR_LOCKOUT = 7; // 0x7

public static final int BIOMETRIC_ERROR_LOCKOUT_PERMANENT = 9; // 0x9

public static final int BIOMETRIC_ERROR_NO_BIOMETRICS = 11; // 0xb

public static final int BIOMETRIC_ERROR_NO_DEVICE_CREDENTIAL = 14; // 0xe

public static final int BIOMETRIC_ERROR_NO_SPACE = 4; // 0x4

public static final int BIOMETRIC_ERROR_SECURITY_UPDATE_REQUIRED = 15; // 0xf

public static final int BIOMETRIC_ERROR_TIMEOUT = 3; // 0x3

public static final int BIOMETRIC_ERROR_UNABLE_TO_PROCESS = 2; // 0x2

public static final int BIOMETRIC_ERROR_USER_CANCELED = 10; // 0xa

public static final int BIOMETRIC_ERROR_VENDOR = 8; // 0x8
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class AuthenticationCallback {

public AuthenticationCallback() { throw new RuntimeException("Stub!"); }

public void onAuthenticationError(int errorCode, java.lang.CharSequence errString) { throw new RuntimeException("Stub!"); }

public void onAuthenticationHelp(int helpCode, java.lang.CharSequence helpString) { throw new RuntimeException("Stub!"); }

public void onAuthenticationSucceeded(android.hardware.biometrics.BiometricPrompt.AuthenticationResult result) { throw new RuntimeException("Stub!"); }

public void onAuthenticationFailed() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class AuthenticationResult {

AuthenticationResult() { throw new RuntimeException("Stub!"); }

public android.hardware.biometrics.BiometricPrompt.CryptoObject getCryptoObject() { throw new RuntimeException("Stub!"); }

public int getAuthenticationType() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder(android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setTitle(@android.annotation.NonNull java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setSubtitle(@android.annotation.NonNull java.lang.CharSequence subtitle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setDescription(@android.annotation.NonNull java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setNegativeButton(@android.annotation.NonNull java.lang.CharSequence text, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.content.DialogInterface.OnClickListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setConfirmationRequired(boolean requireConfirmation) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setDeviceCredentialAllowed(boolean allowed) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt.Builder setAllowedAuthenticators(int authenticators) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.biometrics.BiometricPrompt build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CryptoObject {

public CryptoObject(@android.annotation.NonNull java.security.Signature signature) { throw new RuntimeException("Stub!"); }

public CryptoObject(@android.annotation.NonNull javax.crypto.Cipher cipher) { throw new RuntimeException("Stub!"); }

public CryptoObject(@android.annotation.NonNull javax.crypto.Mac mac) { throw new RuntimeException("Stub!"); }

@Deprecated
public CryptoObject(@android.annotation.NonNull android.security.identity.IdentityCredential credential) { throw new RuntimeException("Stub!"); }

public CryptoObject(@android.annotation.NonNull android.security.identity.PresentationSession session) { throw new RuntimeException("Stub!"); }

public java.security.Signature getSignature() { throw new RuntimeException("Stub!"); }

public javax.crypto.Cipher getCipher() { throw new RuntimeException("Stub!"); }

public javax.crypto.Mac getMac() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.security.identity.IdentityCredential getIdentityCredential() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.security.identity.PresentationSession getPresentationSession() { throw new RuntimeException("Stub!"); }
}

}

