/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/** This class represents a uniquely identifiable package. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class PackageIdentifier {

/**
 * Creates a unique identifier for a package.
 *
 * <p>SHA-256 certificate digests for a signed application can be retrieved with the <a
 * href="{@docRoot}studio/command-line/apksigner/">apksigner tool</a> that is part of the
 * Android SDK build tools. Use {@code apksigner verify --print-certs path/to/apk.apk} to
 * retrieve the SHA-256 certificate digest for the target application. Once retrieved, the
 * SHA-256 certificate digest should be converted to a {@code byte[]} by decoding it in base16:
 *
 * <pre>
 * new android.content.pm.Signature(outputDigest).toByteArray();
 * </pre>
 *
 * @param packageName Name of the package.
 * This value cannot be {@code null}.
 * @param sha256Certificate SHA-256 certificate digest of the package.

 * This value cannot be {@code null}.
 */

public PackageIdentifier(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull byte[] sha256Certificate) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getSha256Certificate() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

