/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/**
 * This class holds JSON that will be passed into a JavaScript function during ad selection. Its
 * contents are not used by <a
 * href="https://developer.android.com/design-for-safety/privacy-sandbox/fledge">FLEDGE</a> platform
 * code, but are merely validated and then passed to the appropriate JavaScript ad selection
 * function.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdSelectionSignals implements android.os.Parcelable {

private AdSelectionSignals() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Compares this AdSelectionSignals to the specified object. The result is true if and only if
 * the argument is not null and is a AdSelectionSignals object with the same string form
 * (obtained by calling {@link #toString()}). Note that this method will not perform any JSON
 * normalization so two AdSelectionSignals objects with the same JSON could be not equal if the
 * String representations of the objects was not equal.
 *
 * @param o The object to compare this AdSelectionSignals against
 * @return true if the given object represents an AdSelectionSignals equivalent to this
 *     AdSelectionSignals, false otherwise
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code corresponding to the string representation of this class obtained by
 * calling {@link #toString()}. Note that this method will not perform any JSON normalization so
 * two AdSelectionSignals objects with the same JSON could have different hash codes if the
 * underlying string representation was different.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return The String form of the JSON wrapped by this class.
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Creates an AdSelectionSignals from a given JSON in String form.
 *
 * @param source Any valid JSON string to create the AdSelectionSignals with.
 * This value cannot be {@code null}.
 * @return An AdSelectionSignals object wrapping the given String.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.common.AdSelectionSignals fromString(@android.annotation.NonNull java.lang.String source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.AdSelectionSignals> CREATOR;
static { CREATOR = null; }

public static final android.adservices.common.AdSelectionSignals EMPTY;
static { EMPTY = null; }
}

