/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.content.Context;
import java.util.concurrent.Executor;

/**
 * AdSelection Manager provides APIs for app and ad-SDKs to run ad selection processes as well
 * as report impressions.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdSelectionManager {

AdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.TestAdSelectionManager getTestAdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Runs the ad selection process on device to select a remarketing ad for the caller
 * application.
 *
 * <p>The input {@code adSelectionConfig} is provided by the Ads SDK and the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} object is transferred via a Binder call. For this reason, the total size
 * of these objects is bound to the Android IPC limitations. Failures to transfer the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} will throws an {@link android.os.TransactionTooLargeException TransactionTooLargeException}.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param adSelectionConfig This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void selectAds(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.AdSelectionOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Report the given impression. The {@link android.adservices.adselection.ReportImpressionRequest ReportImpressionRequest} is provided by the Ads SDK.
 * The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception}
 * indicates the error.
 
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param receiver This value cannot be {@code null}.
 */

public void reportImpression(@android.annotation.NonNull android.adservices.adselection.ReportImpressionRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

