/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.ipsec.ike;


/**
 * This class represents an IKE entity ID based on a DER encoded ASN.1 X.500 Distinguished Name.
 *
 * <p>An example might be "CN=ike.test.android.net, O=Android, C=US".
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeDerAsn1DnIdentification extends android.net.ipsec.ike.IkeIdentification {

/**
 * Construct an instance of IkeDerAsn1DnIdentification with an ASN.1 X.500 Distinguished Name
 *
 * @param derAsn1Dn the ASN.1 X.500 Distinguished Name.

 * This value cannot be {@code null}.
 */

public IkeDerAsn1DnIdentification(@android.annotation.NonNull javax.security.auth.x500.X500Principal derAsn1Dn) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** The ASN.1 X.500 Distinguished Name */

@android.annotation.NonNull public final javax.security.auth.x500.X500Principal derAsn1Dn;
{ derAsn1Dn = null; }
}

