/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.measurement;

import android.content.Context;
import java.util.concurrent.Executor;
import android.view.InputEvent;
import android.os.OutcomeReceiver;

/**
 * MeasurementManager.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MeasurementManager {

MeasurementManager() { throw new RuntimeException("Stub!"); }

/**
 * Register an attribution source (click or view).
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_ATTRIBUTION}
 * @param attributionSource the platform issues a request to this URI in order to fetch metadata
 *     associated with the attribution source.
 * This value cannot be {@code null}.
 * @param inputEvent either an {@link android.view.InputEvent InputEvent} object (for a click event) or null (for a view
 *     event).
 * @param executor used by callback to dispatch results.
 * This value may be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback intended to notify asynchronously the API result.

 * This value may be {@code null}.
 */

public void registerSource(@android.annotation.NonNull android.net.Uri attributionSource, @android.annotation.Nullable android.view.InputEvent inputEvent, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Register an attribution source(click or view) from web context. This API will not process any
 * redirects, all registration URLs should be supplied with the request. At least one of
 * appDestination or webDestination parameters are required to be provided. If the registration
 * is successful, {@code callback}'s {@link android.os.OutcomeReceiver#onResult OutcomeReceiver#onResult} is invoked with null. In
 * case of failure, a {@link java.lang.Exception Exception} is sent through {@code callback}'s {@link android.os.OutcomeReceiver#onError  }. Both success and failure feedback are executed on the provided
 * {@link java.util.concurrent.Executor Executor}.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_ATTRIBUTION}
 * @param request source registration request
 * This value cannot be {@code null}.
 * @param executor used by callback to dispatch results.
 * This value may be {@code null}.
 * @param callback intended to notify asynchronously the API result.

 * This value may be {@code null}.
 */

public void registerWebSource(@android.annotation.NonNull android.adservices.measurement.WebSourceRegistrationRequest request, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Register an attribution trigger(click or view) from web context. This API will not process
 * any redirects, all registration URLs should be supplied with the request. If the registration
 * is successful, {@code callback}'s {@link android.os.OutcomeReceiver#onResult OutcomeReceiver#onResult} is invoked with null. In
 * case of failure, a {@link java.lang.Exception Exception} is sent through {@code callback}'s {@link android.os.OutcomeReceiver#onError  }. Both success and failure feedback are executed on the provided
 * {@link java.util.concurrent.Executor Executor}.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_ATTRIBUTION}
 * @param request trigger registration request
 * This value cannot be {@code null}.
 * @param executor used by callback to dispatch results
 * This value may be {@code null}.
 * @param callback intended to notify asynchronously the API result

 * This value may be {@code null}.
 */

public void registerWebTrigger(@android.annotation.NonNull android.adservices.measurement.WebTriggerRegistrationRequest request, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Register a trigger (conversion).
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_ATTRIBUTION}
 * @param trigger the API issues a request to this URI to fetch metadata associated with the
 *     trigger.
 * This value cannot be {@code null}.
 * @param executor used by callback to dispatch results.
 * This value may be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback intended to notify asynchronously the API result.

 * This value may be {@code null}.
 */

public void registerTrigger(@android.annotation.NonNull android.net.Uri trigger, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Delete previous registrations. If the deletion is successful, the callback's {@link android.os.OutcomeReceiver#onResult  } is invoked with null. In case of failure, a {@link java.lang.Exception Exception} is
 * sent through the callback's {@link android.os.OutcomeReceiver#onError OutcomeReceiver#onError}. Both success and failure
 * feedback are executed on the provided {@link java.util.concurrent.Executor Executor}.
 *
 * @param deletionRequest The request for deleting data.
 * This value cannot be {@code null}.
 * @param executor The executor to run callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback intended to notify asynchronously the API result.

 * This value cannot be {@code null}.
 */

public void deleteRegistrations(@android.annotation.NonNull android.adservices.measurement.DeletionRequest deletionRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Get Measurement API status.
 *
 * <p>The callback's {@code Integer} value is one of {@code MeasurementApiState}.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_ATTRIBUTION}
 * @param executor used by callback to dispatch results.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback intended to notify asynchronously the API result.

 * This value cannot be {@code null}.
 */

public void getMeasurementApiStatus(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Integer,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * This state indicates that Measurement APIs are unavailable. Invoking them will result in an
 * {@link java.lang.UnsupportedOperationException UnsupportedOperationException}.
 */

public static final int MEASUREMENT_API_STATE_DISABLED = 0; // 0x0

/**
 * This state indicates that Measurement APIs are enabled.
 */

public static final int MEASUREMENT_API_STATE_ENABLED = 1; // 0x1
}

