/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.content.Context;
import java.util.concurrent.Executor;

/**
 * CustomAudienceManager provides APIs for app and ad-SDKs to join / leave custom audiences.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CustomAudienceManager {

CustomAudienceManager() { throw new RuntimeException("Stub!"); }

/**
 * Create a service with test-enabling APIs
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.TestCustomAudienceManager getTestCustomAudienceManager() { throw new RuntimeException("Stub!"); }

/**
 * Adds the user to the given {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 *
 * <p>An attempt to register the user for a custom audience with the same combination of {@code
 * ownerPackageName}, {@code buyer}, and {@code name} will cause the existing custom audience's
 * information to be overwritten, including the list of ads data.
 *
 * <p>Note that the ads list can be completely overwritten by the daily background fetch job.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name and/or
 *   <li>the buyer is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with an {@link java.lang.IllegalArgumentException IllegalArgumentException} if
 *
 * <ol>
 *   <li>the storage limit has been exceeded by the calling application and/or
 *   <li>any URI parameters in the {@link android.adservices.customaudience.CustomAudience CustomAudience} given are not authenticated with the
 *       {@link android.adservices.customaudience.CustomAudience CustomAudience} buyer.
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.
 *
 * <p>This call fails with an {@link java.lang.IllegalStateException IllegalStateException} if an internal service error is
 * encountered.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param joinCustomAudienceRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void joinCustomAudience(@android.annotation.NonNull android.adservices.customaudience.JoinCustomAudienceRequest joinCustomAudienceRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Attempts to remove a user from a custom audience by deleting any existing {@link android.adservices.customaudience.CustomAudience CustomAudience} data, identified by {@code ownerPackageName}, {@code buyer}, and {@code
 * name}.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name; and/or
 *   <li>the buyer is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.
 *
 * <p>This call does not inform the caller whether the custom audience specified existed in
 * on-device storage. In other words, it will fail silently when a buyer attempts to leave a
 * custom audience that was not joined.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param leaveCustomAudienceRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void leaveCustomAudience(@android.annotation.NonNull android.adservices.customaudience.LeaveCustomAudienceRequest leaveCustomAudienceRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

