/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.io;

import java.nio.charset.Charset;

/**
 * An InputStreamReader is a bridge from byte streams to character streams: It
 * reads bytes and decodes them into characters using a specified {@link
 * java.nio.charset.Charset charset}.  The charset that it uses
 * may be specified by name or may be given explicitly, or the platform's
 * default charset may be accepted.
 *
 * <p> Each invocation of one of an InputStreamReader's read() methods may
 * cause one or more bytes to be read from the underlying byte-input stream.
 * To enable the efficient conversion of bytes to characters, more bytes may
 * be read ahead from the underlying stream than are necessary to satisfy the
 * current read operation.
 *
 * <p> For top efficiency, consider wrapping an InputStreamReader within a
 * BufferedReader.  For example:
 *
 * <pre>
 * BufferedReader in
 *   = new BufferedReader(new InputStreamReader(System.in));
 * </pre>
 *
 * @see java.io.BufferedReader
 * @see java.io.InputStream
 * @see java.nio.charset.Charset
 *
 * @author      Mark Reinhold
 * @since       JDK1.1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class InputStreamReader extends java.io.Reader {

/**
 * Creates an InputStreamReader that uses the default charset.
 *
 * @param  in   An InputStream
 */

public InputStreamReader(java.io.InputStream in) { throw new RuntimeException("Stub!"); }

/**
 * Creates an InputStreamReader that uses the named charset.
 *
 * @param  in
 *         An InputStream
 *
 * @param  charsetName
 *         The name of a supported
 *         {@link java.nio.charset.Charset charset}
 *
 * @exception  java.io.UnsupportedEncodingException
 *             If the named charset is not supported
 */

public InputStreamReader(java.io.InputStream in, java.lang.String charsetName) throws java.io.UnsupportedEncodingException { throw new RuntimeException("Stub!"); }

/**
 * Creates an InputStreamReader that uses the given charset.
 *
 * @param  in       An InputStream
 * @param  cs       A charset
 *
 * @since 1.4
 * @spec JSR-51
 */

public InputStreamReader(java.io.InputStream in, java.nio.charset.Charset cs) { throw new RuntimeException("Stub!"); }

/**
 * Creates an InputStreamReader that uses the given charset decoder.
 *
 * @param  in       An InputStream
 * @param  dec      A charset decoder
 *
 * @since 1.4
 * @spec JSR-51
 */

public InputStreamReader(java.io.InputStream in, java.nio.charset.CharsetDecoder dec) { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of the character encoding being used by this stream.
 *
 * <p> If the encoding has an historical name then that name is returned;
 * otherwise the encoding's canonical name is returned.
 *
 * <p> If this instance was created with the {@link
 * #InputStreamReader(java.io.InputStream,java.lang.String)} constructor then the returned
 * name, being unique for the encoding, may differ from the name passed to
 * the constructor. This method will return <code>null</code> if the
 * stream has been closed.
 * </p>
 * @return The historical name of this encoding, or
 *         <code>null</code> if the stream has been closed
 *
 * @see java.nio.charset.Charset
 *
 * @revised 1.4
 * @spec JSR-51
 */

public java.lang.String getEncoding() { throw new RuntimeException("Stub!"); }

/**
 * Reads a single character.
 *
 * @return The character read, or -1 if the end of the stream has been
 *         reached
 *
 * @exception  java.io.IOException  If an I/O error occurs
 */

public int read() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Reads characters into a portion of an array.
 *
 * @param      cbuf     Destination buffer
 * @param      offset   Offset at which to start storing characters
 * @param      length   Maximum number of characters to read
 *
 * @return     The number of characters read, or -1 if the end of the
 *             stream has been reached
 *
 * @exception  java.io.IOException  If an I/O error occurs
 */

public int read(char[] cbuf, int offset, int length) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Tells whether this stream is ready to be read.  An InputStreamReader is
 * ready if its input buffer is not empty, or if bytes are available to be
 * read from the underlying byte stream.
 *
 * @exception  java.io.IOException  If an I/O error occurs
 */

public boolean ready() throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void close() throws java.io.IOException { throw new RuntimeException("Stub!"); }
}

