/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telecom;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class Connection extends android.telecom.Conferenceable {

public Connection() { throw new RuntimeException("Stub!"); }

public static java.lang.String capabilitiesToString(int capabilities) { throw new RuntimeException("Stub!"); }

public static java.lang.String propertiesToString(int properties) { throw new RuntimeException("Stub!"); }

public final android.net.Uri getAddress() { throw new RuntimeException("Stub!"); }

public final int getAddressPresentation() { throw new RuntimeException("Stub!"); }

public final java.lang.String getCallerDisplayName() { throw new RuntimeException("Stub!"); }

public final int getCallerDisplayNamePresentation() { throw new RuntimeException("Stub!"); }

public final int getState() { throw new RuntimeException("Stub!"); }

public final int getVideoState() { throw new RuntimeException("Stub!"); }

public final android.telecom.CallAudioState getCallAudioState() { throw new RuntimeException("Stub!"); }

public final android.telecom.Conference getConference() { throw new RuntimeException("Stub!"); }

public final boolean isRingbackRequested() { throw new RuntimeException("Stub!"); }

public final boolean getAudioModeIsVoip() { throw new RuntimeException("Stub!"); }

public final android.telecom.StatusHints getStatusHints() { throw new RuntimeException("Stub!"); }

public final android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public final android.telecom.DisconnectCause getDisconnectCause() { throw new RuntimeException("Stub!"); }

public static java.lang.String stateToString(int state) { throw new RuntimeException("Stub!"); }

public final int getConnectionCapabilities() { throw new RuntimeException("Stub!"); }

public final int getConnectionProperties() { throw new RuntimeException("Stub!"); }

public final void setAddress(android.net.Uri address, int presentation) { throw new RuntimeException("Stub!"); }

public final void setCallerDisplayName(java.lang.String callerDisplayName, int presentation) { throw new RuntimeException("Stub!"); }

public final void setVideoState(int videoState) { throw new RuntimeException("Stub!"); }

public final void setActive() { throw new RuntimeException("Stub!"); }

public final void setRinging() { throw new RuntimeException("Stub!"); }

public final void setInitializing() { throw new RuntimeException("Stub!"); }

public final void setInitialized() { throw new RuntimeException("Stub!"); }

public final void setDialing() { throw new RuntimeException("Stub!"); }

public final void setPulling() { throw new RuntimeException("Stub!"); }

public final void setOnHold() { throw new RuntimeException("Stub!"); }

public final void setVideoProvider(android.telecom.Connection.VideoProvider videoProvider) { throw new RuntimeException("Stub!"); }

public final android.telecom.Connection.VideoProvider getVideoProvider() { throw new RuntimeException("Stub!"); }

public final void setDisconnected(android.telecom.DisconnectCause disconnectCause) { throw new RuntimeException("Stub!"); }

public final void setPostDialWait(java.lang.String remaining) { throw new RuntimeException("Stub!"); }

public final void setNextPostDialChar(char nextChar) { throw new RuntimeException("Stub!"); }

public final void setRingbackRequested(boolean ringback) { throw new RuntimeException("Stub!"); }

public final void setConnectionCapabilities(int connectionCapabilities) { throw new RuntimeException("Stub!"); }

public final void setConnectionProperties(int connectionProperties) { throw new RuntimeException("Stub!"); }

public final void destroy() { throw new RuntimeException("Stub!"); }

public final void setAudioModeIsVoip(boolean isVoip) { throw new RuntimeException("Stub!"); }

public final void setStatusHints(android.telecom.StatusHints statusHints) { throw new RuntimeException("Stub!"); }

public final void setConferenceableConnections(java.util.List<android.telecom.Connection> conferenceableConnections) { throw new RuntimeException("Stub!"); }

public final void setConferenceables(java.util.List<android.telecom.Conferenceable> conferenceables) { throw new RuntimeException("Stub!"); }

public final java.util.List<android.telecom.Conferenceable> getConferenceables() { throw new RuntimeException("Stub!"); }

public final void setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public final void putExtras(@android.annotation.NonNull android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public final void removeExtras(java.util.List<java.lang.String> keys) { throw new RuntimeException("Stub!"); }

public final void removeExtras(java.lang.String... keys) { throw new RuntimeException("Stub!"); }

public final void setAudioRoute(int route) { throw new RuntimeException("Stub!"); }

public void requestBluetoothAudio(@android.annotation.NonNull android.bluetooth.BluetoothDevice bluetoothDevice) { throw new RuntimeException("Stub!"); }

public final void sendRttInitiationSuccess() { throw new RuntimeException("Stub!"); }

public final void sendRttInitiationFailure(int reason) { throw new RuntimeException("Stub!"); }

public final void sendRttSessionRemotelyTerminated() { throw new RuntimeException("Stub!"); }

public final void sendRemoteRttRequest() { throw new RuntimeException("Stub!"); }

public void onCallAudioStateChanged(android.telecom.CallAudioState state) { throw new RuntimeException("Stub!"); }

public void onUsingAlternativeUi(boolean isUsingAlternativeUi) { throw new RuntimeException("Stub!"); }

public void onTrackedByNonUiService(boolean isTracked) { throw new RuntimeException("Stub!"); }

public void onStateChanged(int state) { throw new RuntimeException("Stub!"); }

public void onPlayDtmfTone(char c) { throw new RuntimeException("Stub!"); }

public void onStopDtmfTone() { throw new RuntimeException("Stub!"); }

public void onDisconnect() { throw new RuntimeException("Stub!"); }

public void onSeparate() { throw new RuntimeException("Stub!"); }

public void onAddConferenceParticipants(@android.annotation.NonNull java.util.List<android.net.Uri> participants) { throw new RuntimeException("Stub!"); }

public void onAbort() { throw new RuntimeException("Stub!"); }

public void onHold() { throw new RuntimeException("Stub!"); }

public void onUnhold() { throw new RuntimeException("Stub!"); }

public void onAnswer(int videoState) { throw new RuntimeException("Stub!"); }

public void onAnswer() { throw new RuntimeException("Stub!"); }

public void onDeflect(android.net.Uri address) { throw new RuntimeException("Stub!"); }

public void onReject() { throw new RuntimeException("Stub!"); }

public void onReject(int rejectReason) { throw new RuntimeException("Stub!"); }

public void onReject(java.lang.String replyMessage) { throw new RuntimeException("Stub!"); }

public void onSilence() { throw new RuntimeException("Stub!"); }

public void onPostDialContinue(boolean proceed) { throw new RuntimeException("Stub!"); }

public void onPullExternalCall() { throw new RuntimeException("Stub!"); }

public void onCallEvent(java.lang.String event, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onHandoverComplete() { throw new RuntimeException("Stub!"); }

public void onExtrasChanged(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onShowIncomingCallUi() { throw new RuntimeException("Stub!"); }

public void onStartRtt(@android.annotation.NonNull android.telecom.Connection.RttTextStream rttTextStream) { throw new RuntimeException("Stub!"); }

public void onStopRtt() { throw new RuntimeException("Stub!"); }

public void handleRttUpgradeResponse(@android.annotation.Nullable android.telecom.Connection.RttTextStream rttTextStream) { throw new RuntimeException("Stub!"); }

public static android.telecom.Connection createFailedConnection(android.telecom.DisconnectCause disconnectCause) { throw new RuntimeException("Stub!"); }

public static android.telecom.Connection createCanceledConnection() { throw new RuntimeException("Stub!"); }

public final void notifyConferenceMergeFailed() { throw new RuntimeException("Stub!"); }

public void sendConnectionEvent(java.lang.String event, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public final int getCallerNumberVerificationStatus() { throw new RuntimeException("Stub!"); }

public final void setCallerNumberVerificationStatus(int callerNumberVerificationStatus) { throw new RuntimeException("Stub!"); }

public static final int AUDIO_CODEC_AMR = 1; // 0x1

public static final int AUDIO_CODEC_AMR_WB = 2; // 0x2

public static final int AUDIO_CODEC_EVRC = 4; // 0x4

public static final int AUDIO_CODEC_EVRC_B = 5; // 0x5

public static final int AUDIO_CODEC_EVRC_NW = 7; // 0x7

public static final int AUDIO_CODEC_EVRC_WB = 6; // 0x6

public static final int AUDIO_CODEC_EVS_FB = 20; // 0x14

public static final int AUDIO_CODEC_EVS_NB = 17; // 0x11

public static final int AUDIO_CODEC_EVS_SWB = 19; // 0x13

public static final int AUDIO_CODEC_EVS_WB = 18; // 0x12

public static final int AUDIO_CODEC_G711A = 13; // 0xd

public static final int AUDIO_CODEC_G711AB = 15; // 0xf

public static final int AUDIO_CODEC_G711U = 11; // 0xb

public static final int AUDIO_CODEC_G722 = 14; // 0xe

public static final int AUDIO_CODEC_G723 = 12; // 0xc

public static final int AUDIO_CODEC_G729 = 16; // 0x10

public static final int AUDIO_CODEC_GSM_EFR = 8; // 0x8

public static final int AUDIO_CODEC_GSM_FR = 9; // 0x9

public static final int AUDIO_CODEC_GSM_HR = 10; // 0xa

public static final int AUDIO_CODEC_NONE = 0; // 0x0

public static final int AUDIO_CODEC_QCELP13K = 3; // 0x3

public static final int CAPABILITY_ADD_PARTICIPANT = 67108864; // 0x4000000

public static final int CAPABILITY_CANNOT_DOWNGRADE_VIDEO_TO_AUDIO = 8388608; // 0x800000

public static final int CAPABILITY_CAN_PAUSE_VIDEO = 1048576; // 0x100000

public static final int CAPABILITY_CAN_PULL_CALL = 16777216; // 0x1000000

public static final int CAPABILITY_CAN_SEND_RESPONSE_VIA_CONNECTION = 4194304; // 0x400000

@Deprecated public static final int CAPABILITY_CAN_UPGRADE_TO_VIDEO = 524288; // 0x80000

public static final int CAPABILITY_DISCONNECT_FROM_CONFERENCE = 8192; // 0x2000

public static final int CAPABILITY_HOLD = 1; // 0x1

public static final int CAPABILITY_MANAGE_CONFERENCE = 128; // 0x80

public static final int CAPABILITY_MERGE_CONFERENCE = 4; // 0x4

public static final int CAPABILITY_MUTE = 64; // 0x40

public static final int CAPABILITY_RESPOND_VIA_TEXT = 32; // 0x20

public static final int CAPABILITY_SEPARATE_FROM_CONFERENCE = 4096; // 0x1000

public static final int CAPABILITY_SUPPORTS_VT_LOCAL_BIDIRECTIONAL = 768; // 0x300

public static final int CAPABILITY_SUPPORTS_VT_LOCAL_RX = 256; // 0x100

public static final int CAPABILITY_SUPPORTS_VT_LOCAL_TX = 512; // 0x200

public static final int CAPABILITY_SUPPORTS_VT_REMOTE_BIDIRECTIONAL = 3072; // 0xc00

public static final int CAPABILITY_SUPPORTS_VT_REMOTE_RX = 1024; // 0x400

public static final int CAPABILITY_SUPPORTS_VT_REMOTE_TX = 2048; // 0x800

public static final int CAPABILITY_SUPPORT_DEFLECT = 33554432; // 0x2000000

public static final int CAPABILITY_SUPPORT_HOLD = 2; // 0x2

public static final int CAPABILITY_SWAP_CONFERENCE = 8; // 0x8

public static final java.lang.String EVENT_CALL_HOLD_FAILED = "android.telecom.event.CALL_HOLD_FAILED";

public static final java.lang.String EVENT_CALL_MERGE_FAILED = "android.telecom.event.CALL_MERGE_FAILED";

public static final java.lang.String EVENT_CALL_PULL_FAILED = "android.telecom.event.CALL_PULL_FAILED";

public static final java.lang.String EVENT_CALL_REMOTELY_HELD = "android.telecom.event.CALL_REMOTELY_HELD";

public static final java.lang.String EVENT_CALL_REMOTELY_UNHELD = "android.telecom.event.CALL_REMOTELY_UNHELD";

public static final java.lang.String EVENT_CALL_SWITCH_FAILED = "android.telecom.event.CALL_SWITCH_FAILED";

public static final java.lang.String EVENT_MERGE_COMPLETE = "android.telecom.event.MERGE_COMPLETE";

public static final java.lang.String EVENT_MERGE_START = "android.telecom.event.MERGE_START";

public static final java.lang.String EVENT_ON_HOLD_TONE_END = "android.telecom.event.ON_HOLD_TONE_END";

public static final java.lang.String EVENT_ON_HOLD_TONE_START = "android.telecom.event.ON_HOLD_TONE_START";

public static final java.lang.String EVENT_RTT_AUDIO_INDICATION_CHANGED = "android.telecom.event.RTT_AUDIO_INDICATION_CHANGED";

public static final java.lang.String EXTRA_ANSWERING_DROPS_FG_CALL = "android.telecom.extra.ANSWERING_DROPS_FG_CALL";

public static final java.lang.String EXTRA_ANSWERING_DROPS_FG_CALL_APP_NAME = "android.telecom.extra.ANSWERING_DROPS_FG_CALL_APP_NAME";

public static final java.lang.String EXTRA_AUDIO_CODEC = "android.telecom.extra.AUDIO_CODEC";

public static final java.lang.String EXTRA_AUDIO_CODEC_BANDWIDTH_KHZ = "android.telecom.extra.AUDIO_CODEC_BANDWIDTH_KHZ";

public static final java.lang.String EXTRA_AUDIO_CODEC_BITRATE_KBPS = "android.telecom.extra.AUDIO_CODEC_BITRATE_KBPS";

public static final java.lang.String EXTRA_CALL_SUBJECT = "android.telecom.extra.CALL_SUBJECT";

public static final java.lang.String EXTRA_CHILD_ADDRESS = "android.telecom.extra.CHILD_ADDRESS";

public static final java.lang.String EXTRA_IS_RTT_AUDIO_PRESENT = "android.telecom.extra.IS_RTT_AUDIO_PRESENT";

public static final java.lang.String EXTRA_LAST_FORWARDED_NUMBER = "android.telecom.extra.LAST_FORWARDED_NUMBER";

public static final java.lang.String EXTRA_SIP_INVITE = "android.telecom.extra.SIP_INVITE";

public static final int PROPERTY_ASSISTED_DIALING = 512; // 0x200

public static final int PROPERTY_CROSS_SIM = 8192; // 0x2000

public static final int PROPERTY_HAS_CDMA_VOICE_PRIVACY = 32; // 0x20

public static final int PROPERTY_HIGH_DEF_AUDIO = 4; // 0x4

public static final int PROPERTY_IS_ADHOC_CONFERENCE = 4096; // 0x1000

public static final int PROPERTY_IS_EXTERNAL_CALL = 16; // 0x10

public static final int PROPERTY_IS_RTT = 256; // 0x100

public static final int PROPERTY_NETWORK_IDENTIFIED_EMERGENCY_CALL = 1024; // 0x400

public static final int PROPERTY_SELF_MANAGED = 128; // 0x80

public static final int PROPERTY_WIFI = 8; // 0x8

public static final int STATE_ACTIVE = 4; // 0x4

public static final int STATE_DIALING = 3; // 0x3

public static final int STATE_DISCONNECTED = 6; // 0x6

public static final int STATE_HOLDING = 5; // 0x5

public static final int STATE_INITIALIZING = 0; // 0x0

public static final int STATE_NEW = 1; // 0x1

public static final int STATE_PULLING_CALL = 7; // 0x7

public static final int STATE_RINGING = 2; // 0x2

public static final int VERIFICATION_STATUS_FAILED = 2; // 0x2

public static final int VERIFICATION_STATUS_NOT_VERIFIED = 0; // 0x0

public static final int VERIFICATION_STATUS_PASSED = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RttModifyStatus {

private RttModifyStatus() { throw new RuntimeException("Stub!"); }

public static final int SESSION_MODIFY_REQUEST_FAIL = 2; // 0x2

public static final int SESSION_MODIFY_REQUEST_INVALID = 3; // 0x3

public static final int SESSION_MODIFY_REQUEST_REJECTED_BY_REMOTE = 5; // 0x5

public static final int SESSION_MODIFY_REQUEST_SUCCESS = 1; // 0x1

public static final int SESSION_MODIFY_REQUEST_TIMED_OUT = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RttTextStream {

RttTextStream() { throw new RuntimeException("Stub!"); }

public void write(java.lang.String input) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public java.lang.String read() throws java.io.IOException { throw new RuntimeException("Stub!"); }

public java.lang.String readImmediately() throws java.io.IOException { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class VideoProvider {

public VideoProvider() { throw new RuntimeException("Stub!"); }

public abstract void onSetCamera(java.lang.String cameraId);

public abstract void onSetPreviewSurface(android.view.Surface surface);

public abstract void onSetDisplaySurface(android.view.Surface surface);

public abstract void onSetDeviceOrientation(int rotation);

public abstract void onSetZoom(float value);

public abstract void onSendSessionModifyRequest(android.telecom.VideoProfile fromProfile, android.telecom.VideoProfile toProfile);

public abstract void onSendSessionModifyResponse(android.telecom.VideoProfile responseProfile);

public abstract void onRequestCameraCapabilities();

public abstract void onRequestConnectionDataUsage();

public abstract void onSetPauseImage(android.net.Uri uri);

public void receiveSessionModifyRequest(android.telecom.VideoProfile videoProfile) { throw new RuntimeException("Stub!"); }

public void receiveSessionModifyResponse(int status, android.telecom.VideoProfile requestedProfile, android.telecom.VideoProfile responseProfile) { throw new RuntimeException("Stub!"); }

public void handleCallSessionEvent(int event) { throw new RuntimeException("Stub!"); }

public void changePeerDimensions(int width, int height) { throw new RuntimeException("Stub!"); }

public void setCallDataUsage(long dataUsage) { throw new RuntimeException("Stub!"); }

public void changeCameraCapabilities(android.telecom.VideoProfile.CameraCapabilities cameraCapabilities) { throw new RuntimeException("Stub!"); }

public void changeVideoQuality(int videoQuality) { throw new RuntimeException("Stub!"); }

public static final int SESSION_EVENT_CAMERA_FAILURE = 5; // 0x5

public static final int SESSION_EVENT_CAMERA_PERMISSION_ERROR = 7; // 0x7

public static final int SESSION_EVENT_CAMERA_READY = 6; // 0x6

public static final int SESSION_EVENT_RX_PAUSE = 1; // 0x1

public static final int SESSION_EVENT_RX_RESUME = 2; // 0x2

public static final int SESSION_EVENT_TX_START = 3; // 0x3

public static final int SESSION_EVENT_TX_STOP = 4; // 0x4

public static final int SESSION_MODIFY_REQUEST_FAIL = 2; // 0x2

public static final int SESSION_MODIFY_REQUEST_INVALID = 3; // 0x3

public static final int SESSION_MODIFY_REQUEST_REJECTED_BY_REMOTE = 5; // 0x5

public static final int SESSION_MODIFY_REQUEST_SUCCESS = 1; // 0x1

public static final int SESSION_MODIFY_REQUEST_TIMED_OUT = 4; // 0x4
}

}

