/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MediaRecorder implements android.media.AudioRouting, android.media.AudioRecordingMonitor, android.media.MicrophoneDirection {

@Deprecated
public MediaRecorder() { throw new RuntimeException("Stub!"); }

public MediaRecorder(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

public void setLogSessionId(@android.annotation.NonNull android.media.metrics.LogSessionId id) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.LogSessionId getLogSessionId() { throw new RuntimeException("Stub!"); }

@Deprecated
public native void setCamera(android.hardware.Camera c);

public native android.view.Surface getSurface();

public void setInputSurface(@android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }

public void setPreviewDisplay(android.view.Surface sv) { throw new RuntimeException("Stub!"); }

public native void setAudioSource(int audioSource) throws java.lang.IllegalStateException;

public static final int getAudioSourceMax() { throw new RuntimeException("Stub!"); }

public native void setPrivacySensitive(boolean privacySensitive);

public native boolean isPrivacySensitive();

public native void setVideoSource(int video_source) throws java.lang.IllegalStateException;

public void setProfile(android.media.CamcorderProfile profile) { throw new RuntimeException("Stub!"); }

public void setAudioProfile(@android.annotation.NonNull android.media.EncoderProfiles.AudioProfile profile) { throw new RuntimeException("Stub!"); }

public void setVideoProfile(@android.annotation.NonNull android.media.EncoderProfiles.VideoProfile profile) { throw new RuntimeException("Stub!"); }

public void setCaptureRate(double fps) { throw new RuntimeException("Stub!"); }

public void setOrientationHint(int degrees) { throw new RuntimeException("Stub!"); }

public void setLocation(float latitude, float longitude) { throw new RuntimeException("Stub!"); }

public native void setOutputFormat(int output_format) throws java.lang.IllegalStateException;

public native void setVideoSize(int width, int height) throws java.lang.IllegalStateException;

public native void setVideoFrameRate(int rate) throws java.lang.IllegalStateException;

public native void setMaxDuration(int max_duration_ms) throws java.lang.IllegalArgumentException;

public native void setMaxFileSize(long max_filesize_bytes) throws java.lang.IllegalArgumentException;

public native void setAudioEncoder(int audio_encoder) throws java.lang.IllegalStateException;

public native void setVideoEncoder(int video_encoder) throws java.lang.IllegalStateException;

public void setAudioSamplingRate(int samplingRate) { throw new RuntimeException("Stub!"); }

public void setAudioChannels(int numChannels) { throw new RuntimeException("Stub!"); }

public void setAudioEncodingBitRate(int bitRate) { throw new RuntimeException("Stub!"); }

public void setVideoEncodingBitRate(int bitRate) { throw new RuntimeException("Stub!"); }

public void setVideoEncodingProfileLevel(int profile, int level) { throw new RuntimeException("Stub!"); }

public void setOutputFile(java.io.FileDescriptor fd) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void setOutputFile(java.io.File file) { throw new RuntimeException("Stub!"); }

public void setNextOutputFile(java.io.FileDescriptor fd) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void setOutputFile(java.lang.String path) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void setNextOutputFile(java.io.File file) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void prepare() throws java.io.IOException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public native void start() throws java.lang.IllegalStateException;

public native void stop() throws java.lang.IllegalStateException;

public native void pause() throws java.lang.IllegalStateException;

public native void resume() throws java.lang.IllegalStateException;

public void reset() { throw new RuntimeException("Stub!"); }

public native int getMaxAmplitude() throws java.lang.IllegalStateException;

public void setOnErrorListener(android.media.MediaRecorder.OnErrorListener l) { throw new RuntimeException("Stub!"); }

public void setOnInfoListener(android.media.MediaRecorder.OnInfoListener listener) { throw new RuntimeException("Stub!"); }

public boolean setPreferredDevice(android.media.AudioDeviceInfo deviceInfo) { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getPreferredDevice() { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getRoutedDevice() { throw new RuntimeException("Stub!"); }

public void addOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void removeOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener) { throw new RuntimeException("Stub!"); }

public java.util.List<android.media.MicrophoneInfo> getActiveMicrophones() throws java.io.IOException { throw new RuntimeException("Stub!"); }

public boolean setPreferredMicrophoneDirection(int direction) { throw new RuntimeException("Stub!"); }

public boolean setPreferredMicrophoneFieldDimension(float zoom) { throw new RuntimeException("Stub!"); }

public void registerAudioRecordingCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.AudioManager.AudioRecordingCallback cb) { throw new RuntimeException("Stub!"); }

public void unregisterAudioRecordingCallback(@android.annotation.NonNull android.media.AudioManager.AudioRecordingCallback cb) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.AudioRecordingConfiguration getActiveRecordingConfiguration() { throw new RuntimeException("Stub!"); }

public native void release();

public android.os.PersistableBundle getMetrics() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public static final int MEDIA_ERROR_SERVER_DIED = 100; // 0x64

public static final int MEDIA_RECORDER_ERROR_UNKNOWN = 1; // 0x1

public static final int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800; // 0x320

public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_APPROACHING = 802; // 0x322

public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801; // 0x321

public static final int MEDIA_RECORDER_INFO_NEXT_OUTPUT_FILE_STARTED = 803; // 0x323

public static final int MEDIA_RECORDER_INFO_UNKNOWN = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AudioEncoder {

private AudioEncoder() { throw new RuntimeException("Stub!"); }

public static final int AAC = 3; // 0x3

public static final int AAC_ELD = 5; // 0x5

public static final int AMR_NB = 1; // 0x1

public static final int AMR_WB = 2; // 0x2

public static final int DEFAULT = 0; // 0x0

public static final int HE_AAC = 4; // 0x4

public static final int OPUS = 7; // 0x7

public static final int VORBIS = 6; // 0x6
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AudioSource {

private AudioSource() { throw new RuntimeException("Stub!"); }

public static final int CAMCORDER = 5; // 0x5

public static final int DEFAULT = 0; // 0x0

public static final int MIC = 1; // 0x1

public static final int REMOTE_SUBMIX = 8; // 0x8

public static final int UNPROCESSED = 9; // 0x9

public static final int VOICE_CALL = 4; // 0x4

public static final int VOICE_COMMUNICATION = 7; // 0x7

public static final int VOICE_DOWNLINK = 3; // 0x3

public static final int VOICE_PERFORMANCE = 10; // 0xa

public static final int VOICE_RECOGNITION = 6; // 0x6

public static final int VOICE_UPLINK = 2; // 0x2
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MetricsConstants {

private MetricsConstants() { throw new RuntimeException("Stub!"); }

public static final java.lang.String AUDIO_BITRATE = "android.media.mediarecorder.audio-bitrate";

public static final java.lang.String AUDIO_CHANNELS = "android.media.mediarecorder.audio-channels";

public static final java.lang.String AUDIO_SAMPLERATE = "android.media.mediarecorder.audio-samplerate";

public static final java.lang.String AUDIO_TIMESCALE = "android.media.mediarecorder.audio-timescale";

public static final java.lang.String CAPTURE_FPS = "android.media.mediarecorder.capture-fps";

public static final java.lang.String CAPTURE_FPS_ENABLE = "android.media.mediarecorder.capture-fpsenable";

public static final java.lang.String FRAMERATE = "android.media.mediarecorder.frame-rate";

public static final java.lang.String HEIGHT = "android.media.mediarecorder.height";

public static final java.lang.String MOVIE_TIMESCALE = "android.media.mediarecorder.movie-timescale";

public static final java.lang.String ROTATION = "android.media.mediarecorder.rotation";

public static final java.lang.String VIDEO_BITRATE = "android.media.mediarecorder.video-bitrate";

public static final java.lang.String VIDEO_IFRAME_INTERVAL = "android.media.mediarecorder.video-iframe-interval";

public static final java.lang.String VIDEO_LEVEL = "android.media.mediarecorder.video-encoder-level";

public static final java.lang.String VIDEO_PROFILE = "android.media.mediarecorder.video-encoder-profile";

public static final java.lang.String VIDEO_TIMESCALE = "android.media.mediarecorder.video-timescale";

public static final java.lang.String WIDTH = "android.media.mediarecorder.width";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnErrorListener {

public void onError(android.media.MediaRecorder mr, int what, int extra);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnInfoListener {

public void onInfo(android.media.MediaRecorder mr, int what, int extra);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OutputFormat {

private OutputFormat() { throw new RuntimeException("Stub!"); }

public static final int AAC_ADTS = 6; // 0x6

public static final int AMR_NB = 3; // 0x3

public static final int AMR_WB = 4; // 0x4

public static final int DEFAULT = 0; // 0x0

public static final int MPEG_2_TS = 8; // 0x8

public static final int MPEG_4 = 2; // 0x2

public static final int OGG = 11; // 0xb

@Deprecated public static final int RAW_AMR = 3; // 0x3

public static final int THREE_GPP = 1; // 0x1

public static final int WEBM = 9; // 0x9
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class VideoEncoder {

private VideoEncoder() { throw new RuntimeException("Stub!"); }

public static final int DEFAULT = 0; // 0x0

public static final int H263 = 1; // 0x1

public static final int H264 = 2; // 0x2

public static final int HEVC = 5; // 0x5

public static final int MPEG_4_SP = 3; // 0x3

public static final int VP8 = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class VideoSource {

private VideoSource() { throw new RuntimeException("Stub!"); }

public static final int CAMERA = 1; // 0x1

public static final int DEFAULT = 0; // 0x0

public static final int SURFACE = 2; // 0x2
}

}

