/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MediaPlayer implements android.media.VolumeAutomation, android.media.AudioRouting {

public MediaPlayer() { throw new RuntimeException("Stub!"); }

public void setDisplay(android.view.SurfaceHolder sh) { throw new RuntimeException("Stub!"); }

public void setSurface(android.view.Surface surface) { throw new RuntimeException("Stub!"); }

public void setVideoScalingMode(int mode) { throw new RuntimeException("Stub!"); }

public static android.media.MediaPlayer create(android.content.Context context, android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static android.media.MediaPlayer create(android.content.Context context, android.net.Uri uri, android.view.SurfaceHolder holder) { throw new RuntimeException("Stub!"); }

public static android.media.MediaPlayer create(android.content.Context context, android.net.Uri uri, android.view.SurfaceHolder holder, android.media.AudioAttributes audioAttributes, int audioSessionId) { throw new RuntimeException("Stub!"); }

public static android.media.MediaPlayer create(android.content.Context context, int resid) { throw new RuntimeException("Stub!"); }

public static android.media.MediaPlayer create(android.content.Context context, int resid, android.media.AudioAttributes audioAttributes, int audioSessionId) { throw new RuntimeException("Stub!"); }

public void setDataSource(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri uri) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException, java.lang.SecurityException { throw new RuntimeException("Stub!"); }

public void setDataSource(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.util.Map<java.lang.String,java.lang.String> headers, @android.annotation.Nullable java.util.List<java.net.HttpCookie> cookies) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void setDataSource(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.util.Map<java.lang.String,java.lang.String> headers) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException, java.lang.SecurityException { throw new RuntimeException("Stub!"); }

public void setDataSource(java.lang.String path) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException, java.lang.SecurityException { throw new RuntimeException("Stub!"); }

public void setDataSource(@android.annotation.NonNull android.content.res.AssetFileDescriptor afd) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void setDataSource(java.io.FileDescriptor fd) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void setDataSource(java.io.FileDescriptor fd, long offset, long length) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void setDataSource(android.media.MediaDataSource dataSource) throws java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void prepare() throws java.io.IOException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public native void prepareAsync() throws java.lang.IllegalStateException;

public void start() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void stop() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void pause() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.VolumeShaper createVolumeShaper(@android.annotation.NonNull android.media.VolumeShaper.Configuration configuration) { throw new RuntimeException("Stub!"); }

public boolean setPreferredDevice(android.media.AudioDeviceInfo deviceInfo) { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getPreferredDevice() { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getRoutedDevice() { throw new RuntimeException("Stub!"); }

public void addOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void removeOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener) { throw new RuntimeException("Stub!"); }

public void setWakeMode(android.content.Context context, int mode) { throw new RuntimeException("Stub!"); }

public void setScreenOnWhilePlaying(boolean screenOn) { throw new RuntimeException("Stub!"); }

public native int getVideoWidth();

public native int getVideoHeight();

public android.os.PersistableBundle getMetrics() { throw new RuntimeException("Stub!"); }

public native boolean isPlaying();

public native void setPlaybackParams(@android.annotation.NonNull android.media.PlaybackParams params);

@android.annotation.NonNull
public native android.media.PlaybackParams getPlaybackParams();

public native void setSyncParams(@android.annotation.NonNull android.media.SyncParams params);

@android.annotation.NonNull
public native android.media.SyncParams getSyncParams();

public void seekTo(long msec, int mode) { throw new RuntimeException("Stub!"); }

public void seekTo(int msec) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaTimestamp getTimestamp() { throw new RuntimeException("Stub!"); }

public native int getCurrentPosition();

public native int getDuration();

public native void setNextMediaPlayer(android.media.MediaPlayer next);

public void release() { throw new RuntimeException("Stub!"); }

public void reset() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setAudioStreamType(int streamtype) { throw new RuntimeException("Stub!"); }

public void setAudioAttributes(android.media.AudioAttributes attributes) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

public native void setLooping(boolean looping);

public native boolean isLooping();

public void setVolume(float leftVolume, float rightVolume) { throw new RuntimeException("Stub!"); }

public void setAudioSessionId(int sessionId) throws java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public native int getAudioSessionId();

public native void attachAuxEffect(int effectId);

public void setAuxEffectSendLevel(float level) { throw new RuntimeException("Stub!"); }

public android.media.MediaPlayer.TrackInfo[] getTrackInfo() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void addTimedTextSource(java.lang.String path, java.lang.String mimeType) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void addTimedTextSource(android.content.Context context, android.net.Uri uri, java.lang.String mimeType) throws java.io.IOException, java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void addTimedTextSource(java.io.FileDescriptor fd, java.lang.String mimeType) throws java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void addTimedTextSource(java.io.FileDescriptor fd, long offset, long length, java.lang.String mime) throws java.lang.IllegalArgumentException, java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public int getSelectedTrack(int trackType) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void selectTrack(int index) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void deselectTrack(int index) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public void setOnPreparedListener(android.media.MediaPlayer.OnPreparedListener listener) { throw new RuntimeException("Stub!"); }

public void setOnCompletionListener(android.media.MediaPlayer.OnCompletionListener listener) { throw new RuntimeException("Stub!"); }

public void setOnBufferingUpdateListener(android.media.MediaPlayer.OnBufferingUpdateListener listener) { throw new RuntimeException("Stub!"); }

public void setOnSeekCompleteListener(android.media.MediaPlayer.OnSeekCompleteListener listener) { throw new RuntimeException("Stub!"); }

public void setOnVideoSizeChangedListener(android.media.MediaPlayer.OnVideoSizeChangedListener listener) { throw new RuntimeException("Stub!"); }

public void setOnTimedTextListener(android.media.MediaPlayer.OnTimedTextListener listener) { throw new RuntimeException("Stub!"); }

public void setOnSubtitleDataListener(@android.annotation.NonNull android.media.MediaPlayer.OnSubtitleDataListener listener, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnSubtitleDataListener(@android.annotation.NonNull android.media.MediaPlayer.OnSubtitleDataListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnSubtitleDataListener() { throw new RuntimeException("Stub!"); }

public void setOnMediaTimeDiscontinuityListener(@android.annotation.NonNull android.media.MediaPlayer.OnMediaTimeDiscontinuityListener listener, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnMediaTimeDiscontinuityListener(@android.annotation.NonNull android.media.MediaPlayer.OnMediaTimeDiscontinuityListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnMediaTimeDiscontinuityListener() { throw new RuntimeException("Stub!"); }

public void setOnTimedMetaDataAvailableListener(android.media.MediaPlayer.OnTimedMetaDataAvailableListener listener) { throw new RuntimeException("Stub!"); }

public void setOnErrorListener(android.media.MediaPlayer.OnErrorListener listener) { throw new RuntimeException("Stub!"); }

public void setOnInfoListener(android.media.MediaPlayer.OnInfoListener listener) { throw new RuntimeException("Stub!"); }

public void setOnDrmConfigHelper(android.media.MediaPlayer.OnDrmConfigHelper listener) { throw new RuntimeException("Stub!"); }

public void setOnDrmInfoListener(android.media.MediaPlayer.OnDrmInfoListener listener) { throw new RuntimeException("Stub!"); }

public void setOnDrmInfoListener(android.media.MediaPlayer.OnDrmInfoListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnDrmPreparedListener(android.media.MediaPlayer.OnDrmPreparedListener listener) { throw new RuntimeException("Stub!"); }

public void setOnDrmPreparedListener(android.media.MediaPlayer.OnDrmPreparedListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public android.media.MediaPlayer.DrmInfo getDrmInfo() { throw new RuntimeException("Stub!"); }

public void prepareDrm(@android.annotation.NonNull java.util.UUID uuid) throws android.media.MediaPlayer.ProvisioningNetworkErrorException, android.media.MediaPlayer.ProvisioningServerErrorException, android.media.ResourceBusyException, android.media.UnsupportedSchemeException { throw new RuntimeException("Stub!"); }

public void releaseDrm() throws android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaDrm.KeyRequest getKeyRequest(@android.annotation.Nullable byte[] keySetId, @android.annotation.Nullable byte[] initData, @android.annotation.Nullable java.lang.String mimeType, int keyType, @android.annotation.Nullable java.util.Map<java.lang.String,java.lang.String> optionalParameters) throws android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

public byte[] provideKeyResponse(@android.annotation.Nullable byte[] keySetId, @android.annotation.NonNull byte[] response) throws android.media.DeniedByServerException, android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

public void restoreKeys(@android.annotation.NonNull byte[] keySetId) throws android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDrmPropertyString(@android.annotation.NonNull java.lang.String propertyName) throws android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

public void setDrmPropertyString(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String value) throws android.media.MediaPlayer.NoDrmSchemeException { throw new RuntimeException("Stub!"); }

public static final int MEDIA_ERROR_IO = -1004; // 0xfffffc14

public static final int MEDIA_ERROR_MALFORMED = -1007; // 0xfffffc11

public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200; // 0xc8

public static final int MEDIA_ERROR_SERVER_DIED = 100; // 0x64

public static final int MEDIA_ERROR_TIMED_OUT = -110; // 0xffffff92

public static final int MEDIA_ERROR_UNKNOWN = 1; // 0x1

public static final int MEDIA_ERROR_UNSUPPORTED = -1010; // 0xfffffc0e

public static final int MEDIA_INFO_AUDIO_NOT_PLAYING = 804; // 0x324

public static final int MEDIA_INFO_BAD_INTERLEAVING = 800; // 0x320

public static final int MEDIA_INFO_BUFFERING_END = 702; // 0x2be

public static final int MEDIA_INFO_BUFFERING_START = 701; // 0x2bd

public static final int MEDIA_INFO_METADATA_UPDATE = 802; // 0x322

public static final int MEDIA_INFO_NOT_SEEKABLE = 801; // 0x321

public static final int MEDIA_INFO_STARTED_AS_NEXT = 2; // 0x2

public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902; // 0x386

public static final int MEDIA_INFO_UNKNOWN = 1; // 0x1

public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901; // 0x385

public static final int MEDIA_INFO_VIDEO_NOT_PLAYING = 805; // 0x325

public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3; // 0x3

public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700; // 0x2bc

@Deprecated public static final java.lang.String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";

public static final int PREPARE_DRM_STATUS_PREPARATION_ERROR = 3; // 0x3

public static final int PREPARE_DRM_STATUS_PROVISIONING_NETWORK_ERROR = 1; // 0x1

public static final int PREPARE_DRM_STATUS_PROVISIONING_SERVER_ERROR = 2; // 0x2

public static final int PREPARE_DRM_STATUS_SUCCESS = 0; // 0x0

public static final int SEEK_CLOSEST = 3; // 0x3

public static final int SEEK_CLOSEST_SYNC = 2; // 0x2

public static final int SEEK_NEXT_SYNC = 1; // 0x1

public static final int SEEK_PREVIOUS_SYNC = 0; // 0x0

public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1; // 0x1

public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DrmInfo {

private DrmInfo() { throw new RuntimeException("Stub!"); }

public java.util.Map<java.util.UUID,byte[]> getPssh() { throw new RuntimeException("Stub!"); }

public java.util.UUID[] getSupportedSchemes() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MetricsConstants {

private MetricsConstants() { throw new RuntimeException("Stub!"); }

public static final java.lang.String CODEC_AUDIO = "android.media.mediaplayer.audio.codec";

public static final java.lang.String CODEC_VIDEO = "android.media.mediaplayer.video.codec";

public static final java.lang.String DURATION = "android.media.mediaplayer.durationMs";

public static final java.lang.String ERRORS = "android.media.mediaplayer.err";

public static final java.lang.String ERROR_CODE = "android.media.mediaplayer.errcode";

public static final java.lang.String FRAMES = "android.media.mediaplayer.frames";

public static final java.lang.String FRAMES_DROPPED = "android.media.mediaplayer.dropped";

public static final java.lang.String HEIGHT = "android.media.mediaplayer.height";

public static final java.lang.String MIME_TYPE_AUDIO = "android.media.mediaplayer.audio.mime";

public static final java.lang.String MIME_TYPE_VIDEO = "android.media.mediaplayer.video.mime";

public static final java.lang.String PLAYING = "android.media.mediaplayer.playingMs";

public static final java.lang.String WIDTH = "android.media.mediaplayer.width";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class NoDrmSchemeException extends android.media.MediaDrmException {

public NoDrmSchemeException(java.lang.String detailMessage) { super(null); throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnBufferingUpdateListener {

public void onBufferingUpdate(android.media.MediaPlayer mp, int percent);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnCompletionListener {

public void onCompletion(android.media.MediaPlayer mp);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnDrmConfigHelper {

public void onDrmConfig(android.media.MediaPlayer mp);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnDrmInfoListener {

public void onDrmInfo(android.media.MediaPlayer mp, android.media.MediaPlayer.DrmInfo drmInfo);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnDrmPreparedListener {

public void onDrmPrepared(android.media.MediaPlayer mp, int status);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnErrorListener {

public boolean onError(android.media.MediaPlayer mp, int what, int extra);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnInfoListener {

public boolean onInfo(android.media.MediaPlayer mp, int what, int extra);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMediaTimeDiscontinuityListener {

public void onMediaTimeDiscontinuity(@android.annotation.NonNull android.media.MediaPlayer mp, @android.annotation.NonNull android.media.MediaTimestamp mts);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnPreparedListener {

public void onPrepared(android.media.MediaPlayer mp);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSeekCompleteListener {

public void onSeekComplete(android.media.MediaPlayer mp);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSubtitleDataListener {

public void onSubtitleData(@android.annotation.NonNull android.media.MediaPlayer mp, @android.annotation.NonNull android.media.SubtitleData data);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnTimedMetaDataAvailableListener {

public void onTimedMetaDataAvailable(android.media.MediaPlayer mp, android.media.TimedMetaData data);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnTimedTextListener {

public void onTimedText(android.media.MediaPlayer mp, android.media.TimedText text);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnVideoSizeChangedListener {

public void onVideoSizeChanged(android.media.MediaPlayer mp, int width, int height);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ProvisioningNetworkErrorException extends android.media.MediaDrmException {

public ProvisioningNetworkErrorException(java.lang.String detailMessage) { super(null); throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ProvisioningServerErrorException extends android.media.MediaDrmException {

public ProvisioningServerErrorException(java.lang.String detailMessage) { super(null); throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class TrackInfo implements android.os.Parcelable {

TrackInfo() { throw new RuntimeException("Stub!"); }

public int getTrackType() { throw new RuntimeException("Stub!"); }

public java.lang.String getLanguage() { throw new RuntimeException("Stub!"); }

public android.media.MediaFormat getFormat() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int MEDIA_TRACK_TYPE_AUDIO = 2; // 0x2

public static final int MEDIA_TRACK_TYPE_METADATA = 5; // 0x5

public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4; // 0x4

public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3; // 0x3

public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0; // 0x0

public static final int MEDIA_TRACK_TYPE_VIDEO = 1; // 0x1
}

}

